package zio.aws.memorydb.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DescribeEventsResponse(
    nextToken: Optional[String] = Optional.Absent,
    events: Optional[Iterable[zio.aws.memorydb.model.Event]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.memorydb.model.DescribeEventsResponse = {
    import DescribeEventsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.memorydb.model.DescribeEventsResponse
      .builder()
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .optionallyWith(
        events.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.events)
      .build()
  }
  def asReadOnly: zio.aws.memorydb.model.DescribeEventsResponse.ReadOnly =
    zio.aws.memorydb.model.DescribeEventsResponse.wrap(buildAwsValue())
}
object DescribeEventsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.memorydb.model.DescribeEventsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.memorydb.model.DescribeEventsResponse =
      zio.aws.memorydb.model.DescribeEventsResponse(
        nextToken.map(value => value),
        events.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def nextToken: Optional[String]
    def events: Optional[List[zio.aws.memorydb.model.Event.ReadOnly]]
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getEvents
        : ZIO[Any, AwsError, List[zio.aws.memorydb.model.Event.ReadOnly]] =
      AwsError.unwrapOptionField("events", events)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.memorydb.model.DescribeEventsResponse
  ) extends zio.aws.memorydb.model.DescribeEventsResponse.ReadOnly {
    override val nextToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => value: String)
    override val events: Optional[List[zio.aws.memorydb.model.Event.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.events())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.memorydb.model.Event.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.memorydb.model.DescribeEventsResponse
  ): zio.aws.memorydb.model.DescribeEventsResponse.ReadOnly = new Wrapper(impl)
}
