package zio.aws.memorydb.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class Snapshot(
    name: Optional[String] = Optional.Absent,
    status: Optional[String] = Optional.Absent,
    source: Optional[String] = Optional.Absent,
    kmsKeyId: Optional[String] = Optional.Absent,
    arn: Optional[String] = Optional.Absent,
    clusterConfiguration: Optional[
      zio.aws.memorydb.model.ClusterConfiguration
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.memorydb.model.Snapshot = {
    import Snapshot.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.memorydb.model.Snapshot
      .builder()
      .optionallyWith(name.map(value => value: java.lang.String))(_.name)
      .optionallyWith(status.map(value => value: java.lang.String))(_.status)
      .optionallyWith(source.map(value => value: java.lang.String))(_.source)
      .optionallyWith(kmsKeyId.map(value => value: java.lang.String))(
        _.kmsKeyId
      )
      .optionallyWith(arn.map(value => value: java.lang.String))(_.arn)
      .optionallyWith(clusterConfiguration.map(value => value.buildAwsValue()))(
        _.clusterConfiguration
      )
      .build()
  }
  def asReadOnly: zio.aws.memorydb.model.Snapshot.ReadOnly =
    zio.aws.memorydb.model.Snapshot.wrap(buildAwsValue())
}
object Snapshot {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.memorydb.model.Snapshot] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.memorydb.model.Snapshot =
      zio.aws.memorydb.model.Snapshot(
        name.map(value => value),
        status.map(value => value),
        source.map(value => value),
        kmsKeyId.map(value => value),
        arn.map(value => value),
        clusterConfiguration.map(value => value.asEditable)
      )
    def name: Optional[String]
    def status: Optional[String]
    def source: Optional[String]
    def kmsKeyId: Optional[String]
    def arn: Optional[String]
    def clusterConfiguration
        : Optional[zio.aws.memorydb.model.ClusterConfiguration.ReadOnly]
    def getName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("name", name)
    def getStatus: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("status", status)
    def getSource: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("source", source)
    def getKmsKeyId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("kmsKeyId", kmsKeyId)
    def getArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("arn", arn)
    def getClusterConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.memorydb.model.ClusterConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField("clusterConfiguration", clusterConfiguration)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.memorydb.model.Snapshot
  ) extends zio.aws.memorydb.model.Snapshot.ReadOnly {
    override val name: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => value: String)
    override val status: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.status())
      .map(value => value: String)
    override val source: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.source())
      .map(value => value: String)
    override val kmsKeyId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.kmsKeyId())
      .map(value => value: String)
    override val arn: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.arn())
      .map(value => value: String)
    override val clusterConfiguration
        : Optional[zio.aws.memorydb.model.ClusterConfiguration.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.clusterConfiguration())
        .map(value => zio.aws.memorydb.model.ClusterConfiguration.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.memorydb.model.Snapshot
  ): zio.aws.memorydb.model.Snapshot.ReadOnly = new Wrapper(impl)
}
