package zio.aws.memorydb
import zio.aws.memorydb.model.ResetParameterGroupResponse.ReadOnly
import zio.mock.{Proxy, Mock}
import zio.aws.core.AwsError
import zio.aws.core.aspects.AwsCallAspect
import zio.{IO, ZEnvironment, URLayer}
import zio.aws.memorydb.model.{
  DeleteUserRequest,
  DeleteSubnetGroupRequest,
  UpdateClusterRequest,
  DescribeUsersRequest,
  DescribeSubnetGroupsRequest,
  DescribeAcLsRequest,
  DescribeSnapshotsRequest,
  DeleteSnapshotRequest,
  ResetParameterGroupRequest,
  ListTagsRequest,
  DescribeEngineVersionsRequest,
  DescribeEventsRequest,
  DeleteAclRequest,
  CopySnapshotRequest,
  UpdateParameterGroupRequest,
  CreateParameterGroupRequest,
  CreateClusterRequest,
  UpdateSubnetGroupRequest,
  CreateUserRequest,
  DescribeServiceUpdatesRequest,
  DeleteClusterRequest,
  CreateSubnetGroupRequest,
  ListAllowedNodeTypeUpdatesRequest,
  CreateAclRequest,
  BatchUpdateClusterRequest,
  UpdateAclRequest,
  UntagResourceRequest,
  CreateSnapshotRequest,
  UpdateUserRequest,
  FailoverShardRequest,
  DeleteParameterGroupRequest,
  DescribeParametersRequest,
  DescribeParameterGroupsRequest,
  DescribeClustersRequest,
  TagResourceRequest
}
import software.amazon.awssdk.services.memorydb.MemoryDbAsyncClient
import zio.stream.ZStream
object MemoryDbMock extends Mock[MemoryDb] {
  object ListAllowedNodeTypeUpdates
      extends Effect[
        ListAllowedNodeTypeUpdatesRequest,
        AwsError,
        zio.aws.memorydb.model.ListAllowedNodeTypeUpdatesResponse.ReadOnly
      ]
  object DeleteACL
      extends Effect[
        DeleteAclRequest,
        AwsError,
        zio.aws.memorydb.model.DeleteAclResponse.ReadOnly
      ]
  object DescribeClusters
      extends Stream[
        DescribeClustersRequest,
        AwsError,
        zio.aws.memorydb.model.Cluster.ReadOnly
      ]
  object DescribeClustersPaginated
      extends Effect[
        DescribeClustersRequest,
        AwsError,
        zio.aws.memorydb.model.DescribeClustersResponse.ReadOnly
      ]
  object UpdateUser
      extends Effect[
        UpdateUserRequest,
        AwsError,
        zio.aws.memorydb.model.UpdateUserResponse.ReadOnly
      ]
  object DescribeParameterGroups
      extends Stream[
        DescribeParameterGroupsRequest,
        AwsError,
        zio.aws.memorydb.model.ParameterGroup.ReadOnly
      ]
  object DescribeParameterGroupsPaginated
      extends Effect[
        DescribeParameterGroupsRequest,
        AwsError,
        zio.aws.memorydb.model.DescribeParameterGroupsResponse.ReadOnly
      ]
  object BatchUpdateCluster
      extends Effect[
        BatchUpdateClusterRequest,
        AwsError,
        zio.aws.memorydb.model.BatchUpdateClusterResponse.ReadOnly
      ]
  object ListTags
      extends Effect[
        ListTagsRequest,
        AwsError,
        zio.aws.memorydb.model.ListTagsResponse.ReadOnly
      ]
  object DescribeParameters
      extends Stream[
        DescribeParametersRequest,
        AwsError,
        zio.aws.memorydb.model.Parameter.ReadOnly
      ]
  object DescribeParametersPaginated
      extends Effect[
        DescribeParametersRequest,
        AwsError,
        zio.aws.memorydb.model.DescribeParametersResponse.ReadOnly
      ]
  object CopySnapshot
      extends Effect[
        CopySnapshotRequest,
        AwsError,
        zio.aws.memorydb.model.CopySnapshotResponse.ReadOnly
      ]
  object CreateCluster
      extends Effect[
        CreateClusterRequest,
        AwsError,
        zio.aws.memorydb.model.CreateClusterResponse.ReadOnly
      ]
  object DeleteCluster
      extends Effect[
        DeleteClusterRequest,
        AwsError,
        zio.aws.memorydb.model.DeleteClusterResponse.ReadOnly
      ]
  object CreateACL
      extends Effect[
        CreateAclRequest,
        AwsError,
        zio.aws.memorydb.model.CreateAclResponse.ReadOnly
      ]
  object CreateUser
      extends Effect[
        CreateUserRequest,
        AwsError,
        zio.aws.memorydb.model.CreateUserResponse.ReadOnly
      ]
  object UpdateCluster
      extends Effect[
        UpdateClusterRequest,
        AwsError,
        zio.aws.memorydb.model.UpdateClusterResponse.ReadOnly
      ]
  object DeleteSnapshot
      extends Effect[
        DeleteSnapshotRequest,
        AwsError,
        zio.aws.memorydb.model.DeleteSnapshotResponse.ReadOnly
      ]
  object UpdateParameterGroup
      extends Effect[
        UpdateParameterGroupRequest,
        AwsError,
        zio.aws.memorydb.model.UpdateParameterGroupResponse.ReadOnly
      ]
  object DescribeServiceUpdates
      extends Stream[
        DescribeServiceUpdatesRequest,
        AwsError,
        zio.aws.memorydb.model.ServiceUpdate.ReadOnly
      ]
  object DescribeServiceUpdatesPaginated
      extends Effect[
        DescribeServiceUpdatesRequest,
        AwsError,
        zio.aws.memorydb.model.DescribeServiceUpdatesResponse.ReadOnly
      ]
  object DescribeUsers
      extends Stream[
        DescribeUsersRequest,
        AwsError,
        zio.aws.memorydb.model.User.ReadOnly
      ]
  object DescribeUsersPaginated
      extends Effect[
        DescribeUsersRequest,
        AwsError,
        zio.aws.memorydb.model.DescribeUsersResponse.ReadOnly
      ]
  object UntagResource
      extends Effect[
        UntagResourceRequest,
        AwsError,
        zio.aws.memorydb.model.UntagResourceResponse.ReadOnly
      ]
  object FailoverShard
      extends Effect[
        FailoverShardRequest,
        AwsError,
        zio.aws.memorydb.model.FailoverShardResponse.ReadOnly
      ]
  object UpdateACL
      extends Effect[
        UpdateAclRequest,
        AwsError,
        zio.aws.memorydb.model.UpdateAclResponse.ReadOnly
      ]
  object DescribeEngineVersions
      extends Stream[
        DescribeEngineVersionsRequest,
        AwsError,
        zio.aws.memorydb.model.EngineVersionInfo.ReadOnly
      ]
  object DescribeEngineVersionsPaginated
      extends Effect[
        DescribeEngineVersionsRequest,
        AwsError,
        zio.aws.memorydb.model.DescribeEngineVersionsResponse.ReadOnly
      ]
  object DeleteParameterGroup
      extends Effect[
        DeleteParameterGroupRequest,
        AwsError,
        zio.aws.memorydb.model.DeleteParameterGroupResponse.ReadOnly
      ]
  object DescribeSnapshots
      extends Stream[
        DescribeSnapshotsRequest,
        AwsError,
        zio.aws.memorydb.model.Snapshot.ReadOnly
      ]
  object DescribeSnapshotsPaginated
      extends Effect[
        DescribeSnapshotsRequest,
        AwsError,
        zio.aws.memorydb.model.DescribeSnapshotsResponse.ReadOnly
      ]
  object DeleteSubnetGroup
      extends Effect[
        DeleteSubnetGroupRequest,
        AwsError,
        zio.aws.memorydb.model.DeleteSubnetGroupResponse.ReadOnly
      ]
  object TagResource
      extends Effect[
        TagResourceRequest,
        AwsError,
        zio.aws.memorydb.model.TagResourceResponse.ReadOnly
      ]
  object ResetParameterGroup
      extends Effect[ResetParameterGroupRequest, AwsError, ReadOnly]
  object DeleteUser
      extends Effect[
        DeleteUserRequest,
        AwsError,
        zio.aws.memorydb.model.DeleteUserResponse.ReadOnly
      ]
  object CreateParameterGroup
      extends Effect[
        CreateParameterGroupRequest,
        AwsError,
        zio.aws.memorydb.model.CreateParameterGroupResponse.ReadOnly
      ]
  object DescribeACLs
      extends Stream[
        DescribeAcLsRequest,
        AwsError,
        zio.aws.memorydb.model.ACL.ReadOnly
      ]
  object DescribeACLsPaginated
      extends Effect[
        DescribeAcLsRequest,
        AwsError,
        zio.aws.memorydb.model.DescribeAcLsResponse.ReadOnly
      ]
  object UpdateSubnetGroup
      extends Effect[
        UpdateSubnetGroupRequest,
        AwsError,
        zio.aws.memorydb.model.UpdateSubnetGroupResponse.ReadOnly
      ]
  object CreateSnapshot
      extends Effect[
        CreateSnapshotRequest,
        AwsError,
        zio.aws.memorydb.model.CreateSnapshotResponse.ReadOnly
      ]
  object DescribeSubnetGroups
      extends Stream[
        DescribeSubnetGroupsRequest,
        AwsError,
        zio.aws.memorydb.model.SubnetGroup.ReadOnly
      ]
  object DescribeSubnetGroupsPaginated
      extends Effect[
        DescribeSubnetGroupsRequest,
        AwsError,
        zio.aws.memorydb.model.DescribeSubnetGroupsResponse.ReadOnly
      ]
  object DescribeEvents
      extends Stream[
        DescribeEventsRequest,
        AwsError,
        zio.aws.memorydb.model.Event.ReadOnly
      ]
  object DescribeEventsPaginated
      extends Effect[
        DescribeEventsRequest,
        AwsError,
        zio.aws.memorydb.model.DescribeEventsResponse.ReadOnly
      ]
  object CreateSubnetGroup
      extends Effect[
        CreateSubnetGroupRequest,
        AwsError,
        zio.aws.memorydb.model.CreateSubnetGroupResponse.ReadOnly
      ]
  val compose: URLayer[Proxy, MemoryDb] = zio.ZLayer {
    zio.ZIO.service[Proxy].flatMap { proxy =>
      withRuntime[Proxy, MemoryDb] { rts =>
        zio.ZIO.succeed {
          new MemoryDb {
            val api: MemoryDbAsyncClient = null
            def withAspect[R1](
                newAspect: AwsCallAspect[R1],
                r: ZEnvironment[R1]
            ): MemoryDb = this
            def listAllowedNodeTypeUpdates(
                request: ListAllowedNodeTypeUpdatesRequest
            ): IO[
              AwsError,
              zio.aws.memorydb.model.ListAllowedNodeTypeUpdatesResponse.ReadOnly
            ] = proxy(ListAllowedNodeTypeUpdates, request)
            def deleteACL(
                request: DeleteAclRequest
            ): IO[AwsError, zio.aws.memorydb.model.DeleteAclResponse.ReadOnly] =
              proxy(DeleteACL, request)
            def describeClusters(
                request: DescribeClustersRequest
            ): ZStream[Any, AwsError, zio.aws.memorydb.model.Cluster.ReadOnly] =
              zio.Unsafe.unsafe { implicit u =>
                rts.unsafe
                  .run {
                    proxy(DescribeClusters, request)
                  }
                  .getOrThrowFiberFailure()
              }
            def describeClustersPaginated(request: DescribeClustersRequest): IO[
              AwsError,
              zio.aws.memorydb.model.DescribeClustersResponse.ReadOnly
            ] = proxy(DescribeClustersPaginated, request)
            def updateUser(request: UpdateUserRequest): IO[
              AwsError,
              zio.aws.memorydb.model.UpdateUserResponse.ReadOnly
            ] = proxy(UpdateUser, request)
            def describeParameterGroups(
                request: DescribeParameterGroupsRequest
            ): ZStream[
              Any,
              AwsError,
              zio.aws.memorydb.model.ParameterGroup.ReadOnly
            ] = zio.Unsafe.unsafe { implicit u =>
              rts.unsafe
                .run {
                  proxy(DescribeParameterGroups, request)
                }
                .getOrThrowFiberFailure()
            }
            def describeParameterGroupsPaginated(
                request: DescribeParameterGroupsRequest
            ): IO[
              AwsError,
              zio.aws.memorydb.model.DescribeParameterGroupsResponse.ReadOnly
            ] = proxy(DescribeParameterGroupsPaginated, request)
            def batchUpdateCluster(request: BatchUpdateClusterRequest): IO[
              AwsError,
              zio.aws.memorydb.model.BatchUpdateClusterResponse.ReadOnly
            ] = proxy(BatchUpdateCluster, request)
            def listTags(
                request: ListTagsRequest
            ): IO[AwsError, zio.aws.memorydb.model.ListTagsResponse.ReadOnly] =
              proxy(ListTags, request)
            def describeParameters(request: DescribeParametersRequest): ZStream[
              Any,
              AwsError,
              zio.aws.memorydb.model.Parameter.ReadOnly
            ] = zio.Unsafe.unsafe { implicit u =>
              rts.unsafe
                .run {
                  proxy(DescribeParameters, request)
                }
                .getOrThrowFiberFailure()
            }
            def describeParametersPaginated(
                request: DescribeParametersRequest
            ): IO[
              AwsError,
              zio.aws.memorydb.model.DescribeParametersResponse.ReadOnly
            ] = proxy(DescribeParametersPaginated, request)
            def copySnapshot(request: CopySnapshotRequest): IO[
              AwsError,
              zio.aws.memorydb.model.CopySnapshotResponse.ReadOnly
            ] = proxy(CopySnapshot, request)
            def createCluster(request: CreateClusterRequest): IO[
              AwsError,
              zio.aws.memorydb.model.CreateClusterResponse.ReadOnly
            ] = proxy(CreateCluster, request)
            def deleteCluster(request: DeleteClusterRequest): IO[
              AwsError,
              zio.aws.memorydb.model.DeleteClusterResponse.ReadOnly
            ] = proxy(DeleteCluster, request)
            def createACL(
                request: CreateAclRequest
            ): IO[AwsError, zio.aws.memorydb.model.CreateAclResponse.ReadOnly] =
              proxy(CreateACL, request)
            def createUser(request: CreateUserRequest): IO[
              AwsError,
              zio.aws.memorydb.model.CreateUserResponse.ReadOnly
            ] = proxy(CreateUser, request)
            def updateCluster(request: UpdateClusterRequest): IO[
              AwsError,
              zio.aws.memorydb.model.UpdateClusterResponse.ReadOnly
            ] = proxy(UpdateCluster, request)
            def deleteSnapshot(request: DeleteSnapshotRequest): IO[
              AwsError,
              zio.aws.memorydb.model.DeleteSnapshotResponse.ReadOnly
            ] = proxy(DeleteSnapshot, request)
            def updateParameterGroup(request: UpdateParameterGroupRequest): IO[
              AwsError,
              zio.aws.memorydb.model.UpdateParameterGroupResponse.ReadOnly
            ] = proxy(UpdateParameterGroup, request)
            def describeServiceUpdates(
                request: DescribeServiceUpdatesRequest
            ): ZStream[
              Any,
              AwsError,
              zio.aws.memorydb.model.ServiceUpdate.ReadOnly
            ] = zio.Unsafe.unsafe { implicit u =>
              rts.unsafe
                .run {
                  proxy(DescribeServiceUpdates, request)
                }
                .getOrThrowFiberFailure()
            }
            def describeServiceUpdatesPaginated(
                request: DescribeServiceUpdatesRequest
            ): IO[
              AwsError,
              zio.aws.memorydb.model.DescribeServiceUpdatesResponse.ReadOnly
            ] = proxy(DescribeServiceUpdatesPaginated, request)
            def describeUsers(
                request: DescribeUsersRequest
            ): ZStream[Any, AwsError, zio.aws.memorydb.model.User.ReadOnly] =
              zio.Unsafe.unsafe { implicit u =>
                rts.unsafe
                  .run {
                    proxy(DescribeUsers, request)
                  }
                  .getOrThrowFiberFailure()
              }
            def describeUsersPaginated(request: DescribeUsersRequest): IO[
              AwsError,
              zio.aws.memorydb.model.DescribeUsersResponse.ReadOnly
            ] = proxy(DescribeUsersPaginated, request)
            def untagResource(request: UntagResourceRequest): IO[
              AwsError,
              zio.aws.memorydb.model.UntagResourceResponse.ReadOnly
            ] = proxy(UntagResource, request)
            def failoverShard(request: FailoverShardRequest): IO[
              AwsError,
              zio.aws.memorydb.model.FailoverShardResponse.ReadOnly
            ] = proxy(FailoverShard, request)
            def updateACL(
                request: UpdateAclRequest
            ): IO[AwsError, zio.aws.memorydb.model.UpdateAclResponse.ReadOnly] =
              proxy(UpdateACL, request)
            def describeEngineVersions(
                request: DescribeEngineVersionsRequest
            ): ZStream[
              Any,
              AwsError,
              zio.aws.memorydb.model.EngineVersionInfo.ReadOnly
            ] = zio.Unsafe.unsafe { implicit u =>
              rts.unsafe
                .run {
                  proxy(DescribeEngineVersions, request)
                }
                .getOrThrowFiberFailure()
            }
            def describeEngineVersionsPaginated(
                request: DescribeEngineVersionsRequest
            ): IO[
              AwsError,
              zio.aws.memorydb.model.DescribeEngineVersionsResponse.ReadOnly
            ] = proxy(DescribeEngineVersionsPaginated, request)
            def deleteParameterGroup(request: DeleteParameterGroupRequest): IO[
              AwsError,
              zio.aws.memorydb.model.DeleteParameterGroupResponse.ReadOnly
            ] = proxy(DeleteParameterGroup, request)
            def describeSnapshots(request: DescribeSnapshotsRequest): ZStream[
              Any,
              AwsError,
              zio.aws.memorydb.model.Snapshot.ReadOnly
            ] = zio.Unsafe.unsafe { implicit u =>
              rts.unsafe
                .run {
                  proxy(DescribeSnapshots, request)
                }
                .getOrThrowFiberFailure()
            }
            def describeSnapshotsPaginated(
                request: DescribeSnapshotsRequest
            ): IO[
              AwsError,
              zio.aws.memorydb.model.DescribeSnapshotsResponse.ReadOnly
            ] = proxy(DescribeSnapshotsPaginated, request)
            def deleteSubnetGroup(request: DeleteSubnetGroupRequest): IO[
              AwsError,
              zio.aws.memorydb.model.DeleteSubnetGroupResponse.ReadOnly
            ] = proxy(DeleteSubnetGroup, request)
            def tagResource(request: TagResourceRequest): IO[
              AwsError,
              zio.aws.memorydb.model.TagResourceResponse.ReadOnly
            ] = proxy(TagResource, request)
            def resetParameterGroup(
                request: ResetParameterGroupRequest
            ): IO[AwsError, ReadOnly] = proxy(ResetParameterGroup, request)
            def deleteUser(request: DeleteUserRequest): IO[
              AwsError,
              zio.aws.memorydb.model.DeleteUserResponse.ReadOnly
            ] = proxy(DeleteUser, request)
            def createParameterGroup(request: CreateParameterGroupRequest): IO[
              AwsError,
              zio.aws.memorydb.model.CreateParameterGroupResponse.ReadOnly
            ] = proxy(CreateParameterGroup, request)
            def describeACLs(
                request: DescribeAcLsRequest
            ): ZStream[Any, AwsError, zio.aws.memorydb.model.ACL.ReadOnly] =
              zio.Unsafe.unsafe { implicit u =>
                rts.unsafe
                  .run {
                    proxy(DescribeACLs, request)
                  }
                  .getOrThrowFiberFailure()
              }
            def describeACLsPaginated(request: DescribeAcLsRequest): IO[
              AwsError,
              zio.aws.memorydb.model.DescribeAcLsResponse.ReadOnly
            ] = proxy(DescribeACLsPaginated, request)
            def updateSubnetGroup(request: UpdateSubnetGroupRequest): IO[
              AwsError,
              zio.aws.memorydb.model.UpdateSubnetGroupResponse.ReadOnly
            ] = proxy(UpdateSubnetGroup, request)
            def createSnapshot(request: CreateSnapshotRequest): IO[
              AwsError,
              zio.aws.memorydb.model.CreateSnapshotResponse.ReadOnly
            ] = proxy(CreateSnapshot, request)
            def describeSubnetGroups(
                request: DescribeSubnetGroupsRequest
            ): ZStream[
              Any,
              AwsError,
              zio.aws.memorydb.model.SubnetGroup.ReadOnly
            ] = zio.Unsafe.unsafe { implicit u =>
              rts.unsafe
                .run {
                  proxy(DescribeSubnetGroups, request)
                }
                .getOrThrowFiberFailure()
            }
            def describeSubnetGroupsPaginated(
                request: DescribeSubnetGroupsRequest
            ): IO[
              AwsError,
              zio.aws.memorydb.model.DescribeSubnetGroupsResponse.ReadOnly
            ] = proxy(DescribeSubnetGroupsPaginated, request)
            def describeEvents(
                request: DescribeEventsRequest
            ): ZStream[Any, AwsError, zio.aws.memorydb.model.Event.ReadOnly] =
              zio.Unsafe.unsafe { implicit u =>
                rts.unsafe
                  .run {
                    proxy(DescribeEvents, request)
                  }
                  .getOrThrowFiberFailure()
              }
            def describeEventsPaginated(request: DescribeEventsRequest): IO[
              AwsError,
              zio.aws.memorydb.model.DescribeEventsResponse.ReadOnly
            ] = proxy(DescribeEventsPaginated, request)
            def createSubnetGroup(request: CreateSubnetGroupRequest): IO[
              AwsError,
              zio.aws.memorydb.model.CreateSubnetGroupResponse.ReadOnly
            ] = proxy(CreateSubnetGroup, request)
          }
        }
      }
    }
  }
}
