package zio.aws.memorydb.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class UntagResourceResponse(
    tagList: Optional[Iterable[zio.aws.memorydb.model.Tag]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.memorydb.model.UntagResourceResponse = {
    import UntagResourceResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.memorydb.model.UntagResourceResponse
      .builder()
      .optionallyWith(
        tagList.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tagList)
      .build()
  }
  def asReadOnly: zio.aws.memorydb.model.UntagResourceResponse.ReadOnly =
    zio.aws.memorydb.model.UntagResourceResponse.wrap(buildAwsValue())
}
object UntagResourceResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.memorydb.model.UntagResourceResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.memorydb.model.UntagResourceResponse =
      zio.aws.memorydb.model.UntagResourceResponse(
        tagList.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def tagList: Optional[List[zio.aws.memorydb.model.Tag.ReadOnly]]
    def getTagList
        : ZIO[Any, AwsError, List[zio.aws.memorydb.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tagList", tagList)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.memorydb.model.UntagResourceResponse
  ) extends zio.aws.memorydb.model.UntagResourceResponse.ReadOnly {
    override val tagList: Optional[List[zio.aws.memorydb.model.Tag.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tagList())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.memorydb.model.Tag.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.memorydb.model.UntagResourceResponse
  ): zio.aws.memorydb.model.UntagResourceResponse.ReadOnly = new Wrapper(impl)
}
