package zio.aws.memorydb.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.memorydb.model.primitives.{
  ACLName,
  BooleanOptional,
  IntegerOptional
}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class Cluster(
    name: Optional[String] = Optional.Absent,
    description: Optional[String] = Optional.Absent,
    status: Optional[String] = Optional.Absent,
    pendingUpdates: Optional[zio.aws.memorydb.model.ClusterPendingUpdates] =
      Optional.Absent,
    numberOfShards: Optional[IntegerOptional] = Optional.Absent,
    shards: Optional[Iterable[zio.aws.memorydb.model.Shard]] = Optional.Absent,
    availabilityMode: Optional[zio.aws.memorydb.model.AZStatus] =
      Optional.Absent,
    clusterEndpoint: Optional[zio.aws.memorydb.model.Endpoint] =
      Optional.Absent,
    nodeType: Optional[String] = Optional.Absent,
    engineVersion: Optional[String] = Optional.Absent,
    enginePatchVersion: Optional[String] = Optional.Absent,
    parameterGroupName: Optional[String] = Optional.Absent,
    parameterGroupStatus: Optional[String] = Optional.Absent,
    securityGroups: Optional[
      Iterable[zio.aws.memorydb.model.SecurityGroupMembership]
    ] = Optional.Absent,
    subnetGroupName: Optional[String] = Optional.Absent,
    tlsEnabled: Optional[BooleanOptional] = Optional.Absent,
    kmsKeyId: Optional[String] = Optional.Absent,
    arn: Optional[String] = Optional.Absent,
    snsTopicArn: Optional[String] = Optional.Absent,
    snsTopicStatus: Optional[String] = Optional.Absent,
    snapshotRetentionLimit: Optional[IntegerOptional] = Optional.Absent,
    maintenanceWindow: Optional[String] = Optional.Absent,
    snapshotWindow: Optional[String] = Optional.Absent,
    aclName: Optional[ACLName] = Optional.Absent,
    autoMinorVersionUpgrade: Optional[BooleanOptional] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.memorydb.model.Cluster = {
    import Cluster.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.memorydb.model.Cluster
      .builder()
      .optionallyWith(name.map(value => value: java.lang.String))(_.name)
      .optionallyWith(description.map(value => value: java.lang.String))(
        _.description
      )
      .optionallyWith(status.map(value => value: java.lang.String))(_.status)
      .optionallyWith(pendingUpdates.map(value => value.buildAwsValue()))(
        _.pendingUpdates
      )
      .optionallyWith(numberOfShards.map(value => value: Integer))(
        _.numberOfShards
      )
      .optionallyWith(
        shards.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.shards)
      .optionallyWith(availabilityMode.map(value => value.unwrap))(
        _.availabilityMode
      )
      .optionallyWith(clusterEndpoint.map(value => value.buildAwsValue()))(
        _.clusterEndpoint
      )
      .optionallyWith(nodeType.map(value => value: java.lang.String))(
        _.nodeType
      )
      .optionallyWith(engineVersion.map(value => value: java.lang.String))(
        _.engineVersion
      )
      .optionallyWith(enginePatchVersion.map(value => value: java.lang.String))(
        _.enginePatchVersion
      )
      .optionallyWith(parameterGroupName.map(value => value: java.lang.String))(
        _.parameterGroupName
      )
      .optionallyWith(
        parameterGroupStatus.map(value => value: java.lang.String)
      )(_.parameterGroupStatus)
      .optionallyWith(
        securityGroups.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.securityGroups)
      .optionallyWith(subnetGroupName.map(value => value: java.lang.String))(
        _.subnetGroupName
      )
      .optionallyWith(tlsEnabled.map(value => value: java.lang.Boolean))(
        _.tlsEnabled
      )
      .optionallyWith(kmsKeyId.map(value => value: java.lang.String))(
        _.kmsKeyId
      )
      .optionallyWith(arn.map(value => value: java.lang.String))(_.arn)
      .optionallyWith(snsTopicArn.map(value => value: java.lang.String))(
        _.snsTopicArn
      )
      .optionallyWith(snsTopicStatus.map(value => value: java.lang.String))(
        _.snsTopicStatus
      )
      .optionallyWith(snapshotRetentionLimit.map(value => value: Integer))(
        _.snapshotRetentionLimit
      )
      .optionallyWith(maintenanceWindow.map(value => value: java.lang.String))(
        _.maintenanceWindow
      )
      .optionallyWith(snapshotWindow.map(value => value: java.lang.String))(
        _.snapshotWindow
      )
      .optionallyWith(
        aclName.map(value => ACLName.unwrap(value): java.lang.String)
      )(_.aclName)
      .optionallyWith(
        autoMinorVersionUpgrade.map(value => value: java.lang.Boolean)
      )(_.autoMinorVersionUpgrade)
      .build()
  }
  def asReadOnly: zio.aws.memorydb.model.Cluster.ReadOnly =
    zio.aws.memorydb.model.Cluster.wrap(buildAwsValue())
}
object Cluster {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.memorydb.model.Cluster] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.memorydb.model.Cluster =
      zio.aws.memorydb.model.Cluster(
        name.map(value => value),
        description.map(value => value),
        status.map(value => value),
        pendingUpdates.map(value => value.asEditable),
        numberOfShards.map(value => value),
        shards.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        availabilityMode.map(value => value),
        clusterEndpoint.map(value => value.asEditable),
        nodeType.map(value => value),
        engineVersion.map(value => value),
        enginePatchVersion.map(value => value),
        parameterGroupName.map(value => value),
        parameterGroupStatus.map(value => value),
        securityGroups.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        subnetGroupName.map(value => value),
        tlsEnabled.map(value => value),
        kmsKeyId.map(value => value),
        arn.map(value => value),
        snsTopicArn.map(value => value),
        snsTopicStatus.map(value => value),
        snapshotRetentionLimit.map(value => value),
        maintenanceWindow.map(value => value),
        snapshotWindow.map(value => value),
        aclName.map(value => value),
        autoMinorVersionUpgrade.map(value => value)
      )
    def name: Optional[String]
    def description: Optional[String]
    def status: Optional[String]
    def pendingUpdates
        : Optional[zio.aws.memorydb.model.ClusterPendingUpdates.ReadOnly]
    def numberOfShards: Optional[IntegerOptional]
    def shards: Optional[List[zio.aws.memorydb.model.Shard.ReadOnly]]
    def availabilityMode: Optional[zio.aws.memorydb.model.AZStatus]
    def clusterEndpoint: Optional[zio.aws.memorydb.model.Endpoint.ReadOnly]
    def nodeType: Optional[String]
    def engineVersion: Optional[String]
    def enginePatchVersion: Optional[String]
    def parameterGroupName: Optional[String]
    def parameterGroupStatus: Optional[String]
    def securityGroups: Optional[
      List[zio.aws.memorydb.model.SecurityGroupMembership.ReadOnly]
    ]
    def subnetGroupName: Optional[String]
    def tlsEnabled: Optional[BooleanOptional]
    def kmsKeyId: Optional[String]
    def arn: Optional[String]
    def snsTopicArn: Optional[String]
    def snsTopicStatus: Optional[String]
    def snapshotRetentionLimit: Optional[IntegerOptional]
    def maintenanceWindow: Optional[String]
    def snapshotWindow: Optional[String]
    def aclName: Optional[ACLName]
    def autoMinorVersionUpgrade: Optional[BooleanOptional]
    def getName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("name", name)
    def getDescription: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("description", description)
    def getStatus: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("status", status)
    def getPendingUpdates: ZIO[
      Any,
      AwsError,
      zio.aws.memorydb.model.ClusterPendingUpdates.ReadOnly
    ] = AwsError.unwrapOptionField("pendingUpdates", pendingUpdates)
    def getNumberOfShards: ZIO[Any, AwsError, IntegerOptional] =
      AwsError.unwrapOptionField("numberOfShards", numberOfShards)
    def getShards
        : ZIO[Any, AwsError, List[zio.aws.memorydb.model.Shard.ReadOnly]] =
      AwsError.unwrapOptionField("shards", shards)
    def getAvailabilityMode
        : ZIO[Any, AwsError, zio.aws.memorydb.model.AZStatus] =
      AwsError.unwrapOptionField("availabilityMode", availabilityMode)
    def getClusterEndpoint
        : ZIO[Any, AwsError, zio.aws.memorydb.model.Endpoint.ReadOnly] =
      AwsError.unwrapOptionField("clusterEndpoint", clusterEndpoint)
    def getNodeType: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nodeType", nodeType)
    def getEngineVersion: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("engineVersion", engineVersion)
    def getEnginePatchVersion: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("enginePatchVersion", enginePatchVersion)
    def getParameterGroupName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("parameterGroupName", parameterGroupName)
    def getParameterGroupStatus: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("parameterGroupStatus", parameterGroupStatus)
    def getSecurityGroups: ZIO[Any, AwsError, List[
      zio.aws.memorydb.model.SecurityGroupMembership.ReadOnly
    ]] = AwsError.unwrapOptionField("securityGroups", securityGroups)
    def getSubnetGroupName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("subnetGroupName", subnetGroupName)
    def getTlsEnabled: ZIO[Any, AwsError, BooleanOptional] =
      AwsError.unwrapOptionField("tlsEnabled", tlsEnabled)
    def getKmsKeyId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("kmsKeyId", kmsKeyId)
    def getArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("arn", arn)
    def getSnsTopicArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("snsTopicArn", snsTopicArn)
    def getSnsTopicStatus: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("snsTopicStatus", snsTopicStatus)
    def getSnapshotRetentionLimit: ZIO[Any, AwsError, IntegerOptional] =
      AwsError.unwrapOptionField(
        "snapshotRetentionLimit",
        snapshotRetentionLimit
      )
    def getMaintenanceWindow: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("maintenanceWindow", maintenanceWindow)
    def getSnapshotWindow: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("snapshotWindow", snapshotWindow)
    def getAclName: ZIO[Any, AwsError, ACLName] =
      AwsError.unwrapOptionField("aclName", aclName)
    def getAutoMinorVersionUpgrade: ZIO[Any, AwsError, BooleanOptional] =
      AwsError.unwrapOptionField(
        "autoMinorVersionUpgrade",
        autoMinorVersionUpgrade
      )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.memorydb.model.Cluster
  ) extends zio.aws.memorydb.model.Cluster.ReadOnly {
    override val name: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => value: String)
    override val description: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.description())
      .map(value => value: String)
    override val status: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.status())
      .map(value => value: String)
    override val pendingUpdates
        : Optional[zio.aws.memorydb.model.ClusterPendingUpdates.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.pendingUpdates())
        .map(value => zio.aws.memorydb.model.ClusterPendingUpdates.wrap(value))
    override val numberOfShards: Optional[IntegerOptional] =
      zio.aws.core.internal
        .optionalFromNullable(impl.numberOfShards())
        .map(value => value: IntegerOptional)
    override val shards: Optional[List[zio.aws.memorydb.model.Shard.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.shards())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.memorydb.model.Shard.wrap(item)
          }.toList
        )
    override val availabilityMode: Optional[zio.aws.memorydb.model.AZStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.availabilityMode())
        .map(value => zio.aws.memorydb.model.AZStatus.wrap(value))
    override val clusterEndpoint
        : Optional[zio.aws.memorydb.model.Endpoint.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.clusterEndpoint())
        .map(value => zio.aws.memorydb.model.Endpoint.wrap(value))
    override val nodeType: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.nodeType())
      .map(value => value: String)
    override val engineVersion: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.engineVersion())
      .map(value => value: String)
    override val enginePatchVersion: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.enginePatchVersion())
      .map(value => value: String)
    override val parameterGroupName: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.parameterGroupName())
      .map(value => value: String)
    override val parameterGroupStatus: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.parameterGroupStatus())
      .map(value => value: String)
    override val securityGroups: Optional[
      List[zio.aws.memorydb.model.SecurityGroupMembership.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.securityGroups())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.memorydb.model.SecurityGroupMembership.wrap(item)
        }.toList
      )
    override val subnetGroupName: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.subnetGroupName())
      .map(value => value: String)
    override val tlsEnabled: Optional[BooleanOptional] = zio.aws.core.internal
      .optionalFromNullable(impl.tlsEnabled())
      .map(value => value: BooleanOptional)
    override val kmsKeyId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.kmsKeyId())
      .map(value => value: String)
    override val arn: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.arn())
      .map(value => value: String)
    override val snsTopicArn: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.snsTopicArn())
      .map(value => value: String)
    override val snsTopicStatus: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.snsTopicStatus())
      .map(value => value: String)
    override val snapshotRetentionLimit: Optional[IntegerOptional] =
      zio.aws.core.internal
        .optionalFromNullable(impl.snapshotRetentionLimit())
        .map(value => value: IntegerOptional)
    override val maintenanceWindow: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.maintenanceWindow())
      .map(value => value: String)
    override val snapshotWindow: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.snapshotWindow())
      .map(value => value: String)
    override val aclName: Optional[ACLName] = zio.aws.core.internal
      .optionalFromNullable(impl.aclName())
      .map(value => zio.aws.memorydb.model.primitives.ACLName(value))
    override val autoMinorVersionUpgrade: Optional[BooleanOptional] =
      zio.aws.core.internal
        .optionalFromNullable(impl.autoMinorVersionUpgrade())
        .map(value => value: BooleanOptional)
  }
  def wrap(
      impl: software.amazon.awssdk.services.memorydb.model.Cluster
  ): zio.aws.memorydb.model.Cluster.ReadOnly = new Wrapper(impl)
}
