package zio.aws.memorydb
import zio.prelude.Subtype
import zio.aws.memorydb.model.primitives.{UserName, FilterValue, ACLName}
import java.time.Instant
import zio.aws.memorydb.model.primitives.AccessString.Type
package object model {
  import scala.jdk.CollectionConverters._
  object primitives {
    object ACLName extends Subtype[String]
    type ACLName = zio.aws.memorydb.model.primitives.ACLName.Type
    object AccessString extends Subtype[String]
    type AccessString = zio.aws.memorydb.model.primitives.AccessString.Type
    type BooleanOptional = Boolean
    object FilterName extends Subtype[String]
    type FilterName = zio.aws.memorydb.model.primitives.FilterName.Type
    object FilterValue extends Subtype[String]
    type FilterValue = zio.aws.memorydb.model.primitives.FilterValue.Type
    type Integer = Int
    type IntegerOptional = Int
    object KmsKeyId extends Subtype[String]
    type KmsKeyId = zio.aws.memorydb.model.primitives.KmsKeyId.Type
    object TStamp extends Subtype[Instant]
    type TStamp = zio.aws.memorydb.model.primitives.TStamp.Type
    object TargetBucket extends Subtype[String]
    type TargetBucket = zio.aws.memorydb.model.primitives.TargetBucket.Type
    object UserName extends Subtype[String]
    type UserName = zio.aws.memorydb.model.primitives.UserName.Type
  }
  type ACLClusterNameList = List[String]
  type ACLList = List[zio.aws.memorydb.model.ACL]
  type ACLNameList = List[ACLName]
  type ClusterList = List[zio.aws.memorydb.model.Cluster]
  type ClusterNameList = List[String]
  type EngineVersionInfoList = List[zio.aws.memorydb.model.EngineVersionInfo]
  type EventList = List[zio.aws.memorydb.model.Event]
  type FilterList = List[zio.aws.memorydb.model.Filter]
  type FilterValueList = List[FilterValue]
  type KeyList = List[String]
  type NodeList = List[zio.aws.memorydb.model.Node]
  type NodeTypeList = List[String]
  type ParameterGroupList = List[zio.aws.memorydb.model.ParameterGroup]
  type ParameterNameList = List[String]
  type ParameterNameValueList = List[zio.aws.memorydb.model.ParameterNameValue]
  type ParametersList = List[zio.aws.memorydb.model.Parameter]
  type PasswordListInput = List[String]
  type PendingModifiedServiceUpdateList =
    List[zio.aws.memorydb.model.PendingModifiedServiceUpdate]
  type SecurityGroupIdsList = List[String]
  type SecurityGroupMembershipList =
    List[zio.aws.memorydb.model.SecurityGroupMembership]
  type ServiceUpdateList = List[zio.aws.memorydb.model.ServiceUpdate]
  type ServiceUpdateStatusList =
    List[zio.aws.memorydb.model.ServiceUpdateStatus]
  type ShardDetails = List[zio.aws.memorydb.model.ShardDetail]
  type ShardList = List[zio.aws.memorydb.model.Shard]
  type SnapshotArnsList = List[String]
  type SnapshotList = List[zio.aws.memorydb.model.Snapshot]
  type SubnetGroupList = List[zio.aws.memorydb.model.SubnetGroup]
  type SubnetIdentifierList = List[String]
  type SubnetList = List[zio.aws.memorydb.model.Subnet]
  type TagList = List[zio.aws.memorydb.model.Tag]
  type UnprocessedClusterList = List[zio.aws.memorydb.model.UnprocessedCluster]
  type UserList = List[zio.aws.memorydb.model.User]
  type UserNameList = List[UserName]
  type UserNameListInput = List[UserName]
}
