package zio.aws.memorydb.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.memorydb.model.primitives.{ACLName, IntegerOptional}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class UpdateClusterRequest(
    clusterName: String,
    description: Optional[String] = Optional.Absent,
    securityGroupIds: Optional[Iterable[String]] = Optional.Absent,
    maintenanceWindow: Optional[String] = Optional.Absent,
    snsTopicArn: Optional[String] = Optional.Absent,
    snsTopicStatus: Optional[String] = Optional.Absent,
    parameterGroupName: Optional[String] = Optional.Absent,
    snapshotWindow: Optional[String] = Optional.Absent,
    snapshotRetentionLimit: Optional[IntegerOptional] = Optional.Absent,
    nodeType: Optional[String] = Optional.Absent,
    engineVersion: Optional[String] = Optional.Absent,
    replicaConfiguration: Optional[
      zio.aws.memorydb.model.ReplicaConfigurationRequest
    ] = Optional.Absent,
    shardConfiguration: Optional[
      zio.aws.memorydb.model.ShardConfigurationRequest
    ] = Optional.Absent,
    aclName: Optional[ACLName] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.memorydb.model.UpdateClusterRequest = {
    import UpdateClusterRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.memorydb.model.UpdateClusterRequest
      .builder()
      .clusterName(clusterName: java.lang.String)
      .optionallyWith(description.map(value => value: java.lang.String))(
        _.description
      )
      .optionallyWith(
        securityGroupIds.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.securityGroupIds)
      .optionallyWith(maintenanceWindow.map(value => value: java.lang.String))(
        _.maintenanceWindow
      )
      .optionallyWith(snsTopicArn.map(value => value: java.lang.String))(
        _.snsTopicArn
      )
      .optionallyWith(snsTopicStatus.map(value => value: java.lang.String))(
        _.snsTopicStatus
      )
      .optionallyWith(parameterGroupName.map(value => value: java.lang.String))(
        _.parameterGroupName
      )
      .optionallyWith(snapshotWindow.map(value => value: java.lang.String))(
        _.snapshotWindow
      )
      .optionallyWith(snapshotRetentionLimit.map(value => value: Integer))(
        _.snapshotRetentionLimit
      )
      .optionallyWith(nodeType.map(value => value: java.lang.String))(
        _.nodeType
      )
      .optionallyWith(engineVersion.map(value => value: java.lang.String))(
        _.engineVersion
      )
      .optionallyWith(replicaConfiguration.map(value => value.buildAwsValue()))(
        _.replicaConfiguration
      )
      .optionallyWith(shardConfiguration.map(value => value.buildAwsValue()))(
        _.shardConfiguration
      )
      .optionallyWith(
        aclName.map(value => ACLName.unwrap(value): java.lang.String)
      )(_.aclName)
      .build()
  }
  def asReadOnly: zio.aws.memorydb.model.UpdateClusterRequest.ReadOnly =
    zio.aws.memorydb.model.UpdateClusterRequest.wrap(buildAwsValue())
}
object UpdateClusterRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.memorydb.model.UpdateClusterRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.memorydb.model.UpdateClusterRequest =
      zio.aws.memorydb.model.UpdateClusterRequest(
        clusterName,
        description.map(value => value),
        securityGroupIds.map(value => value),
        maintenanceWindow.map(value => value),
        snsTopicArn.map(value => value),
        snsTopicStatus.map(value => value),
        parameterGroupName.map(value => value),
        snapshotWindow.map(value => value),
        snapshotRetentionLimit.map(value => value),
        nodeType.map(value => value),
        engineVersion.map(value => value),
        replicaConfiguration.map(value => value.asEditable),
        shardConfiguration.map(value => value.asEditable),
        aclName.map(value => value)
      )
    def clusterName: String
    def description: Optional[String]
    def securityGroupIds: Optional[List[String]]
    def maintenanceWindow: Optional[String]
    def snsTopicArn: Optional[String]
    def snsTopicStatus: Optional[String]
    def parameterGroupName: Optional[String]
    def snapshotWindow: Optional[String]
    def snapshotRetentionLimit: Optional[IntegerOptional]
    def nodeType: Optional[String]
    def engineVersion: Optional[String]
    def replicaConfiguration
        : Optional[zio.aws.memorydb.model.ReplicaConfigurationRequest.ReadOnly]
    def shardConfiguration
        : Optional[zio.aws.memorydb.model.ShardConfigurationRequest.ReadOnly]
    def aclName: Optional[ACLName]
    def getClusterName: ZIO[Any, Nothing, String] = ZIO.succeed(clusterName)
    def getDescription: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("description", description)
    def getSecurityGroupIds: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("securityGroupIds", securityGroupIds)
    def getMaintenanceWindow: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("maintenanceWindow", maintenanceWindow)
    def getSnsTopicArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("snsTopicArn", snsTopicArn)
    def getSnsTopicStatus: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("snsTopicStatus", snsTopicStatus)
    def getParameterGroupName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("parameterGroupName", parameterGroupName)
    def getSnapshotWindow: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("snapshotWindow", snapshotWindow)
    def getSnapshotRetentionLimit: ZIO[Any, AwsError, IntegerOptional] =
      AwsError.unwrapOptionField(
        "snapshotRetentionLimit",
        snapshotRetentionLimit
      )
    def getNodeType: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nodeType", nodeType)
    def getEngineVersion: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("engineVersion", engineVersion)
    def getReplicaConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.memorydb.model.ReplicaConfigurationRequest.ReadOnly
    ] = AwsError.unwrapOptionField("replicaConfiguration", replicaConfiguration)
    def getShardConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.memorydb.model.ShardConfigurationRequest.ReadOnly
    ] = AwsError.unwrapOptionField("shardConfiguration", shardConfiguration)
    def getAclName: ZIO[Any, AwsError, ACLName] =
      AwsError.unwrapOptionField("aclName", aclName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.memorydb.model.UpdateClusterRequest
  ) extends zio.aws.memorydb.model.UpdateClusterRequest.ReadOnly {
    override val clusterName: String = impl.clusterName(): String
    override val description: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.description())
      .map(value => value: String)
    override val securityGroupIds: Optional[List[String]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.securityGroupIds())
        .map(value =>
          value.asScala.map { item =>
            item: String
          }.toList
        )
    override val maintenanceWindow: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.maintenanceWindow())
      .map(value => value: String)
    override val snsTopicArn: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.snsTopicArn())
      .map(value => value: String)
    override val snsTopicStatus: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.snsTopicStatus())
      .map(value => value: String)
    override val parameterGroupName: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.parameterGroupName())
      .map(value => value: String)
    override val snapshotWindow: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.snapshotWindow())
      .map(value => value: String)
    override val snapshotRetentionLimit: Optional[IntegerOptional] =
      zio.aws.core.internal
        .optionalFromNullable(impl.snapshotRetentionLimit())
        .map(value => value: IntegerOptional)
    override val nodeType: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.nodeType())
      .map(value => value: String)
    override val engineVersion: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.engineVersion())
      .map(value => value: String)
    override val replicaConfiguration: Optional[
      zio.aws.memorydb.model.ReplicaConfigurationRequest.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.replicaConfiguration())
      .map(value =>
        zio.aws.memorydb.model.ReplicaConfigurationRequest.wrap(value)
      )
    override val shardConfiguration
        : Optional[zio.aws.memorydb.model.ShardConfigurationRequest.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.shardConfiguration())
        .map(value =>
          zio.aws.memorydb.model.ShardConfigurationRequest.wrap(value)
        )
    override val aclName: Optional[ACLName] = zio.aws.core.internal
      .optionalFromNullable(impl.aclName())
      .map(value => zio.aws.memorydb.model.primitives.ACLName(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.memorydb.model.UpdateClusterRequest
  ): zio.aws.memorydb.model.UpdateClusterRequest.ReadOnly = new Wrapper(impl)
}
