package zio.aws.memorydb.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ResetParameterGroupRequest(
    parameterGroupName: String,
    allParameters: Optional[Boolean] = Optional.Absent,
    parameterNames: Optional[Iterable[String]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.memorydb.model.ResetParameterGroupRequest = {
    import ResetParameterGroupRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.memorydb.model.ResetParameterGroupRequest
      .builder()
      .parameterGroupName(parameterGroupName: java.lang.String)
      .optionallyWith(allParameters.map(value => value: java.lang.Boolean))(
        _.allParameters
      )
      .optionallyWith(
        parameterNames.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.parameterNames)
      .build()
  }
  def asReadOnly: zio.aws.memorydb.model.ResetParameterGroupRequest.ReadOnly =
    zio.aws.memorydb.model.ResetParameterGroupRequest.wrap(buildAwsValue())
}
object ResetParameterGroupRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.memorydb.model.ResetParameterGroupRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.memorydb.model.ResetParameterGroupRequest =
      zio.aws.memorydb.model.ResetParameterGroupRequest(
        parameterGroupName,
        allParameters.map(value => value),
        parameterNames.map(value => value)
      )
    def parameterGroupName: String
    def allParameters: Optional[Boolean]
    def parameterNames: Optional[List[String]]
    def getParameterGroupName: ZIO[Any, Nothing, String] =
      ZIO.succeed(parameterGroupName)
    def getAllParameters: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("allParameters", allParameters)
    def getParameterNames: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("parameterNames", parameterNames)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.memorydb.model.ResetParameterGroupRequest
  ) extends zio.aws.memorydb.model.ResetParameterGroupRequest.ReadOnly {
    override val parameterGroupName: String = impl.parameterGroupName(): String
    override val allParameters: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.allParameters())
      .map(value => value: Boolean)
    override val parameterNames: Optional[List[String]] = zio.aws.core.internal
      .optionalFromNullable(impl.parameterNames())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.memorydb.model.ResetParameterGroupRequest
  ): zio.aws.memorydb.model.ResetParameterGroupRequest.ReadOnly = new Wrapper(
    impl
  )
}
