package zio.aws.memorydb.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ParameterGroup(
    name: Optional[String] = Optional.Absent,
    family: Optional[String] = Optional.Absent,
    description: Optional[String] = Optional.Absent,
    arn: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.memorydb.model.ParameterGroup = {
    import ParameterGroup.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.memorydb.model.ParameterGroup
      .builder()
      .optionallyWith(name.map(value => value: java.lang.String))(_.name)
      .optionallyWith(family.map(value => value: java.lang.String))(_.family)
      .optionallyWith(description.map(value => value: java.lang.String))(
        _.description
      )
      .optionallyWith(arn.map(value => value: java.lang.String))(_.arn)
      .build()
  }
  def asReadOnly: zio.aws.memorydb.model.ParameterGroup.ReadOnly =
    zio.aws.memorydb.model.ParameterGroup.wrap(buildAwsValue())
}
object ParameterGroup {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.memorydb.model.ParameterGroup
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.memorydb.model.ParameterGroup =
      zio.aws.memorydb.model.ParameterGroup(
        name.map(value => value),
        family.map(value => value),
        description.map(value => value),
        arn.map(value => value)
      )
    def name: Optional[String]
    def family: Optional[String]
    def description: Optional[String]
    def arn: Optional[String]
    def getName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("name", name)
    def getFamily: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("family", family)
    def getDescription: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("description", description)
    def getArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("arn", arn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.memorydb.model.ParameterGroup
  ) extends zio.aws.memorydb.model.ParameterGroup.ReadOnly {
    override val name: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => value: String)
    override val family: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.family())
      .map(value => value: String)
    override val description: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.description())
      .map(value => value: String)
    override val arn: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.arn())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.memorydb.model.ParameterGroup
  ): zio.aws.memorydb.model.ParameterGroup.ReadOnly = new Wrapper(impl)
}
