package zio.aws.memorydb.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.memorydb.model.primitives.IntegerOptional
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class DescribeSubnetGroupsRequest(
    subnetGroupName: Optional[String] = Optional.Absent,
    maxResults: Optional[IntegerOptional] = Optional.Absent,
    nextToken: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.memorydb.model.DescribeSubnetGroupsRequest = {
    import DescribeSubnetGroupsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.memorydb.model.DescribeSubnetGroupsRequest
      .builder()
      .optionallyWith(subnetGroupName.map(value => value: java.lang.String))(
        _.subnetGroupName
      )
      .optionallyWith(maxResults.map(value => value: Integer))(_.maxResults)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .build()
  }
  def asReadOnly: zio.aws.memorydb.model.DescribeSubnetGroupsRequest.ReadOnly =
    zio.aws.memorydb.model.DescribeSubnetGroupsRequest.wrap(buildAwsValue())
}
object DescribeSubnetGroupsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.memorydb.model.DescribeSubnetGroupsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.memorydb.model.DescribeSubnetGroupsRequest =
      zio.aws.memorydb.model.DescribeSubnetGroupsRequest(
        subnetGroupName.map(value => value),
        maxResults.map(value => value),
        nextToken.map(value => value)
      )
    def subnetGroupName: Optional[String]
    def maxResults: Optional[IntegerOptional]
    def nextToken: Optional[String]
    def getSubnetGroupName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("subnetGroupName", subnetGroupName)
    def getMaxResults: ZIO[Any, AwsError, IntegerOptional] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.memorydb.model.DescribeSubnetGroupsRequest
  ) extends zio.aws.memorydb.model.DescribeSubnetGroupsRequest.ReadOnly {
    override val subnetGroupName: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.subnetGroupName())
      .map(value => value: String)
    override val maxResults: Optional[IntegerOptional] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value => value: IntegerOptional)
    override val nextToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.memorydb.model.DescribeSubnetGroupsRequest
  ): zio.aws.memorydb.model.DescribeSubnetGroupsRequest.ReadOnly = new Wrapper(
    impl
  )
}
