package zio.aws.memorydb.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DescribeServiceUpdatesResponse(
    nextToken: Optional[String] = Optional.Absent,
    serviceUpdates: Optional[Iterable[zio.aws.memorydb.model.ServiceUpdate]] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.memorydb.model.DescribeServiceUpdatesResponse = {
    import DescribeServiceUpdatesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.memorydb.model.DescribeServiceUpdatesResponse
      .builder()
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .optionallyWith(
        serviceUpdates.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.serviceUpdates)
      .build()
  }
  def asReadOnly
      : zio.aws.memorydb.model.DescribeServiceUpdatesResponse.ReadOnly =
    zio.aws.memorydb.model.DescribeServiceUpdatesResponse.wrap(buildAwsValue())
}
object DescribeServiceUpdatesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.memorydb.model.DescribeServiceUpdatesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.memorydb.model.DescribeServiceUpdatesResponse =
      zio.aws.memorydb.model.DescribeServiceUpdatesResponse(
        nextToken.map(value => value),
        serviceUpdates.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def nextToken: Optional[String]
    def serviceUpdates
        : Optional[List[zio.aws.memorydb.model.ServiceUpdate.ReadOnly]]
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getServiceUpdates: ZIO[Any, AwsError, List[
      zio.aws.memorydb.model.ServiceUpdate.ReadOnly
    ]] = AwsError.unwrapOptionField("serviceUpdates", serviceUpdates)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.memorydb.model.DescribeServiceUpdatesResponse
  ) extends zio.aws.memorydb.model.DescribeServiceUpdatesResponse.ReadOnly {
    override val nextToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => value: String)
    override val serviceUpdates
        : Optional[List[zio.aws.memorydb.model.ServiceUpdate.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.serviceUpdates())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.memorydb.model.ServiceUpdate.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.memorydb.model.DescribeServiceUpdatesResponse
  ): zio.aws.memorydb.model.DescribeServiceUpdatesResponse.ReadOnly =
    new Wrapper(impl)
}
