package zio.aws.memorydb.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.memorydb.model.primitives.IntegerOptional
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class DescribeAcLsRequest(
    aclName: Optional[String] = Optional.Absent,
    maxResults: Optional[IntegerOptional] = Optional.Absent,
    nextToken: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.memorydb.model.DescribeAcLsRequest = {
    import DescribeAcLsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.memorydb.model.DescribeAcLsRequest
      .builder()
      .optionallyWith(aclName.map(value => value: java.lang.String))(_.aclName)
      .optionallyWith(maxResults.map(value => value: Integer))(_.maxResults)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .build()
  }
  def asReadOnly: zio.aws.memorydb.model.DescribeAcLsRequest.ReadOnly =
    zio.aws.memorydb.model.DescribeAcLsRequest.wrap(buildAwsValue())
}
object DescribeAcLsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.memorydb.model.DescribeAcLsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.memorydb.model.DescribeAcLsRequest =
      zio.aws.memorydb.model.DescribeAcLsRequest(
        aclName.map(value => value),
        maxResults.map(value => value),
        nextToken.map(value => value)
      )
    def aclName: Optional[String]
    def maxResults: Optional[IntegerOptional]
    def nextToken: Optional[String]
    def getAclName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("aclName", aclName)
    def getMaxResults: ZIO[Any, AwsError, IntegerOptional] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.memorydb.model.DescribeAcLsRequest
  ) extends zio.aws.memorydb.model.DescribeAcLsRequest.ReadOnly {
    override val aclName: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.aclName())
      .map(value => value: String)
    override val maxResults: Optional[IntegerOptional] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value => value: IntegerOptional)
    override val nextToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.memorydb.model.DescribeAcLsRequest
  ): zio.aws.memorydb.model.DescribeAcLsRequest.ReadOnly = new Wrapper(impl)
}
