package zio.aws.memorydb.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class UpdateAclResponse(
    acl: Option[zio.aws.memorydb.model.ACL] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.memorydb.model.UpdateAclResponse = {
    import UpdateAclResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.memorydb.model.UpdateAclResponse
      .builder()
      .optionallyWith(acl.map(value => value.buildAwsValue()))(_.acl)
      .build()
  }
  def asReadOnly: zio.aws.memorydb.model.UpdateAclResponse.ReadOnly =
    zio.aws.memorydb.model.UpdateAclResponse.wrap(buildAwsValue())
}
object UpdateAclResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.memorydb.model.UpdateAclResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.memorydb.model.UpdateAclResponse =
      zio.aws.memorydb.model
        .UpdateAclResponse(acl.map(value => value.asEditable))
    def acl: Option[zio.aws.memorydb.model.ACL.ReadOnly]
    def getAcl: ZIO[Any, AwsError, zio.aws.memorydb.model.ACL.ReadOnly] =
      AwsError.unwrapOptionField("acl", acl)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.memorydb.model.UpdateAclResponse
  ) extends zio.aws.memorydb.model.UpdateAclResponse.ReadOnly {
    override val acl: Option[zio.aws.memorydb.model.ACL.ReadOnly] = scala
      .Option(impl.acl())
      .map(value => zio.aws.memorydb.model.ACL.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.memorydb.model.UpdateAclResponse
  ): zio.aws.memorydb.model.UpdateAclResponse.ReadOnly = new Wrapper(impl)
}
