package zio.aws.memorydb.model
import zio.ZIO
import zio.aws.memorydb.model.primitives.{FilterValue, FilterName}
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class Filter(name: FilterName, values: Iterable[FilterValue]) {
  def buildAwsValue(): software.amazon.awssdk.services.memorydb.model.Filter = {
    import Filter.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.memorydb.model.Filter
      .builder()
      .name(FilterName.unwrap(name): java.lang.String)
      .values(values.map { item =>
        FilterValue.unwrap(item): java.lang.String
      }.asJavaCollection)
      .build()
  }
  def asReadOnly: zio.aws.memorydb.model.Filter.ReadOnly =
    zio.aws.memorydb.model.Filter.wrap(buildAwsValue())
}
object Filter {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.memorydb.model.Filter] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.memorydb.model.Filter =
      zio.aws.memorydb.model.Filter(name, values)
    def name: FilterName
    def values: List[FilterValue]
    def getName: ZIO[Any, Nothing, FilterName] = ZIO.succeed(name)
    def getValues: ZIO[Any, Nothing, List[FilterValue]] = ZIO.succeed(values)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.memorydb.model.Filter
  ) extends zio.aws.memorydb.model.Filter.ReadOnly {
    override val name: FilterName =
      zio.aws.memorydb.model.primitives.FilterName(impl.name())
    override val values: List[FilterValue] = impl
      .values()
      .asScala
      .map { item =>
        zio.aws.memorydb.model.primitives.FilterValue(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.memorydb.model.Filter
  ): zio.aws.memorydb.model.Filter.ReadOnly = new Wrapper(impl)
}
