package zio.aws.memorydb.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class DescribeSnapshotsResponse(
    nextToken: Option[String] = None,
    snapshots: Option[Iterable[zio.aws.memorydb.model.Snapshot]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.memorydb.model.DescribeSnapshotsResponse = {
    import DescribeSnapshotsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.memorydb.model.DescribeSnapshotsResponse
      .builder()
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .optionallyWith(
        snapshots.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.snapshots)
      .build()
  }
  def asReadOnly: zio.aws.memorydb.model.DescribeSnapshotsResponse.ReadOnly =
    zio.aws.memorydb.model.DescribeSnapshotsResponse.wrap(buildAwsValue())
}
object DescribeSnapshotsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.memorydb.model.DescribeSnapshotsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.memorydb.model.DescribeSnapshotsResponse =
      zio.aws.memorydb.model.DescribeSnapshotsResponse(
        nextToken.map(value => value),
        snapshots.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def nextToken: Option[String]
    def snapshots: Option[List[zio.aws.memorydb.model.Snapshot.ReadOnly]]
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getSnapshots
        : ZIO[Any, AwsError, List[zio.aws.memorydb.model.Snapshot.ReadOnly]] =
      AwsError.unwrapOptionField("snapshots", snapshots)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.memorydb.model.DescribeSnapshotsResponse
  ) extends zio.aws.memorydb.model.DescribeSnapshotsResponse.ReadOnly {
    override val nextToken: Option[String] =
      scala.Option(impl.nextToken()).map(value => value: String)
    override val snapshots
        : Option[List[zio.aws.memorydb.model.Snapshot.ReadOnly]] = scala
      .Option(impl.snapshots())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.memorydb.model.Snapshot.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.memorydb.model.DescribeSnapshotsResponse
  ): zio.aws.memorydb.model.DescribeSnapshotsResponse.ReadOnly = new Wrapper(
    impl
  )
}
