package zio.aws.memorydb.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class CreateUserResponse(
    user: Option[zio.aws.memorydb.model.User] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.memorydb.model.CreateUserResponse = {
    import CreateUserResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.memorydb.model.CreateUserResponse
      .builder()
      .optionallyWith(user.map(value => value.buildAwsValue()))(_.user)
      .build()
  }
  def asReadOnly: zio.aws.memorydb.model.CreateUserResponse.ReadOnly =
    zio.aws.memorydb.model.CreateUserResponse.wrap(buildAwsValue())
}
object CreateUserResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.memorydb.model.CreateUserResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.memorydb.model.CreateUserResponse =
      zio.aws.memorydb.model
        .CreateUserResponse(user.map(value => value.asEditable))
    def user: Option[zio.aws.memorydb.model.User.ReadOnly]
    def getUser: ZIO[Any, AwsError, zio.aws.memorydb.model.User.ReadOnly] =
      AwsError.unwrapOptionField("user", user)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.memorydb.model.CreateUserResponse
  ) extends zio.aws.memorydb.model.CreateUserResponse.ReadOnly {
    override val user: Option[zio.aws.memorydb.model.User.ReadOnly] = scala
      .Option(impl.user())
      .map(value => zio.aws.memorydb.model.User.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.memorydb.model.CreateUserResponse
  ): zio.aws.memorydb.model.CreateUserResponse.ReadOnly = new Wrapper(impl)
}
