package zio.aws.memorydb.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class UnprocessedCluster(
    clusterName: Option[String] = None,
    errorType: Option[String] = None,
    errorMessage: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.memorydb.model.UnprocessedCluster = {
    import UnprocessedCluster.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.memorydb.model.UnprocessedCluster
      .builder()
      .optionallyWith(clusterName.map(value => value: java.lang.String))(
        _.clusterName
      )
      .optionallyWith(errorType.map(value => value: java.lang.String))(
        _.errorType
      )
      .optionallyWith(errorMessage.map(value => value: java.lang.String))(
        _.errorMessage
      )
      .build()
  }
  def asReadOnly: zio.aws.memorydb.model.UnprocessedCluster.ReadOnly =
    zio.aws.memorydb.model.UnprocessedCluster.wrap(buildAwsValue())
}
object UnprocessedCluster {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.memorydb.model.UnprocessedCluster
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.memorydb.model.UnprocessedCluster =
      zio.aws.memorydb.model.UnprocessedCluster(
        clusterName.map(value => value),
        errorType.map(value => value),
        errorMessage.map(value => value)
      )
    def clusterName: Option[String]
    def errorType: Option[String]
    def errorMessage: Option[String]
    def getClusterName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("clusterName", clusterName)
    def getErrorType: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("errorType", errorType)
    def getErrorMessage: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("errorMessage", errorMessage)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.memorydb.model.UnprocessedCluster
  ) extends zio.aws.memorydb.model.UnprocessedCluster.ReadOnly {
    override val clusterName: Option[String] =
      scala.Option(impl.clusterName()).map(value => value: String)
    override val errorType: Option[String] =
      scala.Option(impl.errorType()).map(value => value: String)
    override val errorMessage: Option[String] =
      scala.Option(impl.errorMessage()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.memorydb.model.UnprocessedCluster
  ): zio.aws.memorydb.model.UnprocessedCluster.ReadOnly = new Wrapper(impl)
}
