package zio.aws.memorydb.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class DeleteAclResponse(
    acl: Option[zio.aws.memorydb.model.ACL] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.memorydb.model.DeleteAclResponse = {
    import DeleteAclResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.memorydb.model.DeleteAclResponse
      .builder()
      .optionallyWith(acl.map(value => value.buildAwsValue()))(_.acl)
      .build()
  }
  def asReadOnly: zio.aws.memorydb.model.DeleteAclResponse.ReadOnly =
    zio.aws.memorydb.model.DeleteAclResponse.wrap(buildAwsValue())
}
object DeleteAclResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.memorydb.model.DeleteAclResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.memorydb.model.DeleteAclResponse =
      zio.aws.memorydb.model
        .DeleteAclResponse(acl.map(value => value.asEditable))
    def acl: Option[zio.aws.memorydb.model.ACL.ReadOnly]
    def getAcl: ZIO[Any, AwsError, zio.aws.memorydb.model.ACL.ReadOnly] =
      AwsError.unwrapOptionField("acl", acl)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.memorydb.model.DeleteAclResponse
  ) extends zio.aws.memorydb.model.DeleteAclResponse.ReadOnly {
    override val acl: Option[zio.aws.memorydb.model.ACL.ReadOnly] = scala
      .Option(impl.acl())
      .map(value => zio.aws.memorydb.model.ACL.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.memorydb.model.DeleteAclResponse
  ): zio.aws.memorydb.model.DeleteAclResponse.ReadOnly = new Wrapper(impl)
}
