package zio.aws.memorydb.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class DescribeAcLsResponse(
    acLs: Option[Iterable[zio.aws.memorydb.model.ACL]] = None,
    nextToken: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.memorydb.model.DescribeAcLsResponse = {
    import DescribeAcLsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.memorydb.model.DescribeAcLsResponse
      .builder()
      .optionallyWith(
        acLs.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.acLs)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .build()
  }
  def asReadOnly: zio.aws.memorydb.model.DescribeAcLsResponse.ReadOnly =
    zio.aws.memorydb.model.DescribeAcLsResponse.wrap(buildAwsValue())
}
object DescribeAcLsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.memorydb.model.DescribeAcLsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.memorydb.model.DescribeAcLsResponse =
      zio.aws.memorydb.model.DescribeAcLsResponse(
        acLs.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def acLs: Option[List[zio.aws.memorydb.model.ACL.ReadOnly]]
    def nextToken: Option[String]
    def getAcLs: ZIO[Any, AwsError, List[zio.aws.memorydb.model.ACL.ReadOnly]] =
      AwsError.unwrapOptionField("acLs", acLs)
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.memorydb.model.DescribeAcLsResponse
  ) extends zio.aws.memorydb.model.DescribeAcLsResponse.ReadOnly {
    override val acLs: Option[List[zio.aws.memorydb.model.ACL.ReadOnly]] = scala
      .Option(impl.acLs())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.memorydb.model.ACL.wrap(item)
        }.toList
      )
    override val nextToken: Option[String] =
      scala.Option(impl.nextToken()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.memorydb.model.DescribeAcLsResponse
  ): zio.aws.memorydb.model.DescribeAcLsResponse.ReadOnly = new Wrapper(impl)
}
