package zio.aws.memorydb.model
import java.lang.Integer
import zio.ZIO
import zio.aws.memorydb.model.primitives.IntegerOptional
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class Shard(
    name: Option[String] = None,
    status: Option[String] = None,
    slots: Option[String] = None,
    nodes: Option[Iterable[zio.aws.memorydb.model.Node]] = None,
    numberOfNodes: Option[IntegerOptional] = None
) {
  def buildAwsValue(): software.amazon.awssdk.services.memorydb.model.Shard = {
    import Shard.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.memorydb.model.Shard
      .builder()
      .optionallyWith(name.map(value => value: java.lang.String))(_.name)
      .optionallyWith(status.map(value => value: java.lang.String))(_.status)
      .optionallyWith(slots.map(value => value: java.lang.String))(_.slots)
      .optionallyWith(
        nodes.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.nodes)
      .optionallyWith(numberOfNodes.map(value => value: Integer))(
        _.numberOfNodes
      )
      .build()
  }
  def asReadOnly: zio.aws.memorydb.model.Shard.ReadOnly =
    zio.aws.memorydb.model.Shard.wrap(buildAwsValue())
}
object Shard {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.memorydb.model.Shard] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.memorydb.model.Shard = zio.aws.memorydb.model.Shard(
      name.map(value => value),
      status.map(value => value),
      slots.map(value => value),
      nodes.map(value =>
        value.map { item =>
          item.asEditable
        }
      ),
      numberOfNodes.map(value => value)
    )
    def name: Option[String]
    def status: Option[String]
    def slots: Option[String]
    def nodes: Option[List[zio.aws.memorydb.model.Node.ReadOnly]]
    def numberOfNodes: Option[IntegerOptional]
    def getName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("name", name)
    def getStatus: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("status", status)
    def getSlots: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("slots", slots)
    def getNodes
        : ZIO[Any, AwsError, List[zio.aws.memorydb.model.Node.ReadOnly]] =
      AwsError.unwrapOptionField("nodes", nodes)
    def getNumberOfNodes: ZIO[Any, AwsError, IntegerOptional] =
      AwsError.unwrapOptionField("numberOfNodes", numberOfNodes)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.memorydb.model.Shard
  ) extends zio.aws.memorydb.model.Shard.ReadOnly {
    override val name: Option[String] =
      scala.Option(impl.name()).map(value => value: String)
    override val status: Option[String] =
      scala.Option(impl.status()).map(value => value: String)
    override val slots: Option[String] =
      scala.Option(impl.slots()).map(value => value: String)
    override val nodes: Option[List[zio.aws.memorydb.model.Node.ReadOnly]] =
      scala
        .Option(impl.nodes())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.memorydb.model.Node.wrap(item)
          }.toList
        )
    override val numberOfNodes: Option[IntegerOptional] =
      scala.Option(impl.numberOfNodes()).map(value => value: IntegerOptional)
  }
  def wrap(
      impl: software.amazon.awssdk.services.memorydb.model.Shard
  ): zio.aws.memorydb.model.Shard.ReadOnly = new Wrapper(impl)
}
