package zio.aws.memorydb.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class PendingModifiedServiceUpdate(
    serviceUpdateName: Option[String] = None,
    status: Option[zio.aws.memorydb.model.ServiceUpdateStatus] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.memorydb.model.PendingModifiedServiceUpdate = {
    import PendingModifiedServiceUpdate.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.memorydb.model.PendingModifiedServiceUpdate
      .builder()
      .optionallyWith(serviceUpdateName.map(value => value: java.lang.String))(
        _.serviceUpdateName
      )
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .build()
  }
  def asReadOnly: zio.aws.memorydb.model.PendingModifiedServiceUpdate.ReadOnly =
    zio.aws.memorydb.model.PendingModifiedServiceUpdate.wrap(buildAwsValue())
}
object PendingModifiedServiceUpdate {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.memorydb.model.PendingModifiedServiceUpdate
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.memorydb.model.PendingModifiedServiceUpdate =
      zio.aws.memorydb.model.PendingModifiedServiceUpdate(
        serviceUpdateName.map(value => value),
        status.map(value => value)
      )
    def serviceUpdateName: Option[String]
    def status: Option[zio.aws.memorydb.model.ServiceUpdateStatus]
    def getServiceUpdateName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("serviceUpdateName", serviceUpdateName)
    def getStatus
        : ZIO[Any, AwsError, zio.aws.memorydb.model.ServiceUpdateStatus] =
      AwsError.unwrapOptionField("status", status)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.memorydb.model.PendingModifiedServiceUpdate
  ) extends zio.aws.memorydb.model.PendingModifiedServiceUpdate.ReadOnly {
    override val serviceUpdateName: Option[String] =
      scala.Option(impl.serviceUpdateName()).map(value => value: String)
    override val status: Option[zio.aws.memorydb.model.ServiceUpdateStatus] =
      scala
        .Option(impl.status())
        .map(value => zio.aws.memorydb.model.ServiceUpdateStatus.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.memorydb.model.PendingModifiedServiceUpdate
  ): zio.aws.memorydb.model.PendingModifiedServiceUpdate.ReadOnly = new Wrapper(
    impl
  )
}
