package zio.aws.memorydb.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class DeleteClusterResponse(
    cluster: Option[zio.aws.memorydb.model.Cluster] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.memorydb.model.DeleteClusterResponse = {
    import DeleteClusterResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.memorydb.model.DeleteClusterResponse
      .builder()
      .optionallyWith(cluster.map(value => value.buildAwsValue()))(_.cluster)
      .build()
  }
  def asReadOnly: zio.aws.memorydb.model.DeleteClusterResponse.ReadOnly =
    zio.aws.memorydb.model.DeleteClusterResponse.wrap(buildAwsValue())
}
object DeleteClusterResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.memorydb.model.DeleteClusterResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.memorydb.model.DeleteClusterResponse =
      zio.aws.memorydb.model
        .DeleteClusterResponse(cluster.map(value => value.asEditable))
    def cluster: Option[zio.aws.memorydb.model.Cluster.ReadOnly]
    def getCluster
        : ZIO[Any, AwsError, zio.aws.memorydb.model.Cluster.ReadOnly] =
      AwsError.unwrapOptionField("cluster", cluster)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.memorydb.model.DeleteClusterResponse
  ) extends zio.aws.memorydb.model.DeleteClusterResponse.ReadOnly {
    override val cluster: Option[zio.aws.memorydb.model.Cluster.ReadOnly] =
      scala
        .Option(impl.cluster())
        .map(value => zio.aws.memorydb.model.Cluster.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.memorydb.model.DeleteClusterResponse
  ): zio.aws.memorydb.model.DeleteClusterResponse.ReadOnly = new Wrapper(impl)
}
