package zio.aws.memorydb.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ReshardingStatus(
    slotMigration: Option[zio.aws.memorydb.model.SlotMigration] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.memorydb.model.ReshardingStatus = {
    import ReshardingStatus.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.memorydb.model.ReshardingStatus
      .builder()
      .optionallyWith(slotMigration.map(value => value.buildAwsValue()))(
        _.slotMigration
      )
      .build()
  }
  def asReadOnly: zio.aws.memorydb.model.ReshardingStatus.ReadOnly =
    zio.aws.memorydb.model.ReshardingStatus.wrap(buildAwsValue())
}
object ReshardingStatus {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.memorydb.model.ReshardingStatus
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.memorydb.model.ReshardingStatus =
      zio.aws.memorydb.model
        .ReshardingStatus(slotMigration.map(value => value.asEditable))
    def slotMigration: Option[zio.aws.memorydb.model.SlotMigration.ReadOnly]
    def getSlotMigration
        : ZIO[Any, AwsError, zio.aws.memorydb.model.SlotMigration.ReadOnly] =
      AwsError.unwrapOptionField("slotMigration", slotMigration)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.memorydb.model.ReshardingStatus
  ) extends zio.aws.memorydb.model.ReshardingStatus.ReadOnly {
    override val slotMigration
        : Option[zio.aws.memorydb.model.SlotMigration.ReadOnly] = scala
      .Option(impl.slotMigration())
      .map(value => zio.aws.memorydb.model.SlotMigration.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.memorydb.model.ReshardingStatus
  ): zio.aws.memorydb.model.ReshardingStatus.ReadOnly = new Wrapper(impl)
}
