package zio.aws.memorydb.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class DeleteClusterRequest(
    clusterName: String,
    finalSnapshotName: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.memorydb.model.DeleteClusterRequest = {
    import DeleteClusterRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.memorydb.model.DeleteClusterRequest
      .builder()
      .clusterName(clusterName: java.lang.String)
      .optionallyWith(finalSnapshotName.map(value => value: java.lang.String))(
        _.finalSnapshotName
      )
      .build()
  }
  def asReadOnly: zio.aws.memorydb.model.DeleteClusterRequest.ReadOnly =
    zio.aws.memorydb.model.DeleteClusterRequest.wrap(buildAwsValue())
}
object DeleteClusterRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.memorydb.model.DeleteClusterRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.memorydb.model.DeleteClusterRequest =
      zio.aws.memorydb.model.DeleteClusterRequest(
        clusterName,
        finalSnapshotName.map(value => value)
      )
    def clusterName: String
    def finalSnapshotName: Option[String]
    def getClusterName: ZIO[Any, Nothing, String] = ZIO.succeed(clusterName)
    def getFinalSnapshotName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("finalSnapshotName", finalSnapshotName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.memorydb.model.DeleteClusterRequest
  ) extends zio.aws.memorydb.model.DeleteClusterRequest.ReadOnly {
    override val clusterName: String = impl.clusterName(): String
    override val finalSnapshotName: Option[String] =
      scala.Option(impl.finalSnapshotName()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.memorydb.model.DeleteClusterRequest
  ): zio.aws.memorydb.model.DeleteClusterRequest.ReadOnly = new Wrapper(impl)
}
