package zio.aws.memorydb.model
import zio.ZIO
import zio.aws.memorydb.model.primitives.Integer
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ShardConfigurationRequest(shardCount: Option[Integer] = None) {
  def buildAwsValue()
      : software.amazon.awssdk.services.memorydb.model.ShardConfigurationRequest = {
    import ShardConfigurationRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.memorydb.model.ShardConfigurationRequest
      .builder()
      .optionallyWith(shardCount.map(value => value: java.lang.Integer))(
        _.shardCount
      )
      .build()
  }
  def asReadOnly: zio.aws.memorydb.model.ShardConfigurationRequest.ReadOnly =
    zio.aws.memorydb.model.ShardConfigurationRequest.wrap(buildAwsValue())
}
object ShardConfigurationRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.memorydb.model.ShardConfigurationRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.memorydb.model.ShardConfigurationRequest =
      zio.aws.memorydb.model
        .ShardConfigurationRequest(shardCount.map(value => value))
    def shardCount: Option[Integer]
    def getShardCount: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("shardCount", shardCount)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.memorydb.model.ShardConfigurationRequest
  ) extends zio.aws.memorydb.model.ShardConfigurationRequest.ReadOnly {
    override val shardCount: Option[Integer] =
      scala.Option(impl.shardCount()).map(value => value: Integer)
  }
  def wrap(
      impl: software.amazon.awssdk.services.memorydb.model.ShardConfigurationRequest
  ): zio.aws.memorydb.model.ShardConfigurationRequest.ReadOnly = new Wrapper(
    impl
  )
}
