package zio.aws.memorydb.model
import java.lang.Integer
import zio.ZIO
import zio.aws.memorydb.model.primitives.{IntegerOptional, UserName}
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class DescribeUsersRequest(
    userName: Option[UserName] = None,
    filters: Option[Iterable[zio.aws.memorydb.model.Filter]] = None,
    maxResults: Option[IntegerOptional] = None,
    nextToken: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.memorydb.model.DescribeUsersRequest = {
    import DescribeUsersRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.memorydb.model.DescribeUsersRequest
      .builder()
      .optionallyWith(
        userName.map(value => UserName.unwrap(value): java.lang.String)
      )(_.userName)
      .optionallyWith(
        filters.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.filters)
      .optionallyWith(maxResults.map(value => value: Integer))(_.maxResults)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .build()
  }
  def asReadOnly: zio.aws.memorydb.model.DescribeUsersRequest.ReadOnly =
    zio.aws.memorydb.model.DescribeUsersRequest.wrap(buildAwsValue())
}
object DescribeUsersRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.memorydb.model.DescribeUsersRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.memorydb.model.DescribeUsersRequest =
      zio.aws.memorydb.model.DescribeUsersRequest(
        userName.map(value => value),
        filters.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        maxResults.map(value => value),
        nextToken.map(value => value)
      )
    def userName: Option[UserName]
    def filters: Option[List[zio.aws.memorydb.model.Filter.ReadOnly]]
    def maxResults: Option[IntegerOptional]
    def nextToken: Option[String]
    def getUserName: ZIO[Any, AwsError, UserName] =
      AwsError.unwrapOptionField("userName", userName)
    def getFilters
        : ZIO[Any, AwsError, List[zio.aws.memorydb.model.Filter.ReadOnly]] =
      AwsError.unwrapOptionField("filters", filters)
    def getMaxResults: ZIO[Any, AwsError, IntegerOptional] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.memorydb.model.DescribeUsersRequest
  ) extends zio.aws.memorydb.model.DescribeUsersRequest.ReadOnly {
    override val userName: Option[UserName] = scala
      .Option(impl.userName())
      .map(value => zio.aws.memorydb.model.primitives.UserName(value))
    override val filters: Option[List[zio.aws.memorydb.model.Filter.ReadOnly]] =
      scala
        .Option(impl.filters())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.memorydb.model.Filter.wrap(item)
          }.toList
        )
    override val maxResults: Option[IntegerOptional] =
      scala.Option(impl.maxResults()).map(value => value: IntegerOptional)
    override val nextToken: Option[String] =
      scala.Option(impl.nextToken()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.memorydb.model.DescribeUsersRequest
  ): zio.aws.memorydb.model.DescribeUsersRequest.ReadOnly = new Wrapper(impl)
}
