package zio.aws.memorydb.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class CopySnapshotResponse(
    snapshot: Option[zio.aws.memorydb.model.Snapshot] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.memorydb.model.CopySnapshotResponse = {
    import CopySnapshotResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.memorydb.model.CopySnapshotResponse
      .builder()
      .optionallyWith(snapshot.map(value => value.buildAwsValue()))(_.snapshot)
      .build()
  }
  def asReadOnly: zio.aws.memorydb.model.CopySnapshotResponse.ReadOnly =
    zio.aws.memorydb.model.CopySnapshotResponse.wrap(buildAwsValue())
}
object CopySnapshotResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.memorydb.model.CopySnapshotResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.memorydb.model.CopySnapshotResponse =
      zio.aws.memorydb.model
        .CopySnapshotResponse(snapshot.map(value => value.asEditable))
    def snapshot: Option[zio.aws.memorydb.model.Snapshot.ReadOnly]
    def getSnapshot
        : ZIO[Any, AwsError, zio.aws.memorydb.model.Snapshot.ReadOnly] =
      AwsError.unwrapOptionField("snapshot", snapshot)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.memorydb.model.CopySnapshotResponse
  ) extends zio.aws.memorydb.model.CopySnapshotResponse.ReadOnly {
    override val snapshot: Option[zio.aws.memorydb.model.Snapshot.ReadOnly] =
      scala
        .Option(impl.snapshot())
        .map(value => zio.aws.memorydb.model.Snapshot.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.memorydb.model.CopySnapshotResponse
  ): zio.aws.memorydb.model.CopySnapshotResponse.ReadOnly = new Wrapper(impl)
}
