package zio.aws.memorydb.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class CreateSnapshotRequest(
    clusterName: String,
    snapshotName: String,
    kmsKeyId: Option[String] = None,
    tags: Option[Iterable[zio.aws.memorydb.model.Tag]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.memorydb.model.CreateSnapshotRequest = {
    import CreateSnapshotRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.memorydb.model.CreateSnapshotRequest
      .builder()
      .clusterName(clusterName: java.lang.String)
      .snapshotName(snapshotName: java.lang.String)
      .optionallyWith(kmsKeyId.map(value => value: java.lang.String))(
        _.kmsKeyId
      )
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .build()
  }
  def asReadOnly: zio.aws.memorydb.model.CreateSnapshotRequest.ReadOnly =
    zio.aws.memorydb.model.CreateSnapshotRequest.wrap(buildAwsValue())
}
object CreateSnapshotRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.memorydb.model.CreateSnapshotRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.memorydb.model.CreateSnapshotRequest =
      zio.aws.memorydb.model.CreateSnapshotRequest(
        clusterName,
        snapshotName,
        kmsKeyId.map(value => value),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def clusterName: String
    def snapshotName: String
    def kmsKeyId: Option[String]
    def tags: Option[List[zio.aws.memorydb.model.Tag.ReadOnly]]
    def getClusterName: ZIO[Any, Nothing, String] = ZIO.succeed(clusterName)
    def getSnapshotName: ZIO[Any, Nothing, String] = ZIO.succeed(snapshotName)
    def getKmsKeyId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("kmsKeyId", kmsKeyId)
    def getTags: ZIO[Any, AwsError, List[zio.aws.memorydb.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.memorydb.model.CreateSnapshotRequest
  ) extends zio.aws.memorydb.model.CreateSnapshotRequest.ReadOnly {
    override val clusterName: String = impl.clusterName(): String
    override val snapshotName: String = impl.snapshotName(): String
    override val kmsKeyId: Option[String] =
      scala.Option(impl.kmsKeyId()).map(value => value: String)
    override val tags: Option[List[zio.aws.memorydb.model.Tag.ReadOnly]] = scala
      .Option(impl.tags())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.memorydb.model.Tag.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.memorydb.model.CreateSnapshotRequest
  ): zio.aws.memorydb.model.CreateSnapshotRequest.ReadOnly = new Wrapper(impl)
}
