package zio.aws.memorydb.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class Tag(key: Option[String] = None, value: Option[String] = None) {
  def buildAwsValue(): software.amazon.awssdk.services.memorydb.model.Tag = {
    import Tag.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.memorydb.model.Tag
      .builder()
      .optionallyWith(key.map(value => value: java.lang.String))(_.key)
      .optionallyWith(value.map(value => value: java.lang.String))(_.value)
      .build()
  }
  def asReadOnly: zio.aws.memorydb.model.Tag.ReadOnly =
    zio.aws.memorydb.model.Tag.wrap(buildAwsValue())
}
object Tag {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.memorydb.model.Tag] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.memorydb.model.Tag = zio.aws.memorydb.model
      .Tag(key.map(value => value), value.map(value => value))
    def key: Option[String]
    def value: Option[String]
    def getKey: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("key", key)
    def getValue: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("value", value)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.memorydb.model.Tag
  ) extends zio.aws.memorydb.model.Tag.ReadOnly {
    override val key: Option[String] =
      scala.Option(impl.key()).map(value => value: String)
    override val value: Option[String] =
      scala.Option(impl.value()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.memorydb.model.Tag
  ): zio.aws.memorydb.model.Tag.ReadOnly = new Wrapper(impl)
}
