package zio.aws.memorydb.model
import java.lang.Integer
import zio.ZIO
import zio.aws.memorydb.model.primitives.IntegerOptional
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ClusterConfiguration(
    name: Option[String] = None,
    description: Option[String] = None,
    nodeType: Option[String] = None,
    engineVersion: Option[String] = None,
    maintenanceWindow: Option[String] = None,
    topicArn: Option[String] = None,
    port: Option[IntegerOptional] = None,
    parameterGroupName: Option[String] = None,
    subnetGroupName: Option[String] = None,
    vpcId: Option[String] = None,
    snapshotRetentionLimit: Option[IntegerOptional] = None,
    snapshotWindow: Option[String] = None,
    numShards: Option[IntegerOptional] = None,
    shards: Option[Iterable[zio.aws.memorydb.model.ShardDetail]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.memorydb.model.ClusterConfiguration = {
    import ClusterConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.memorydb.model.ClusterConfiguration
      .builder()
      .optionallyWith(name.map(value => value: java.lang.String))(_.name)
      .optionallyWith(description.map(value => value: java.lang.String))(
        _.description
      )
      .optionallyWith(nodeType.map(value => value: java.lang.String))(
        _.nodeType
      )
      .optionallyWith(engineVersion.map(value => value: java.lang.String))(
        _.engineVersion
      )
      .optionallyWith(maintenanceWindow.map(value => value: java.lang.String))(
        _.maintenanceWindow
      )
      .optionallyWith(topicArn.map(value => value: java.lang.String))(
        _.topicArn
      )
      .optionallyWith(
        port.map(value => IntegerOptional.unwrap(value): Integer)
      )(_.port)
      .optionallyWith(parameterGroupName.map(value => value: java.lang.String))(
        _.parameterGroupName
      )
      .optionallyWith(subnetGroupName.map(value => value: java.lang.String))(
        _.subnetGroupName
      )
      .optionallyWith(vpcId.map(value => value: java.lang.String))(_.vpcId)
      .optionallyWith(
        snapshotRetentionLimit.map(value =>
          IntegerOptional.unwrap(value): Integer
        )
      )(_.snapshotRetentionLimit)
      .optionallyWith(snapshotWindow.map(value => value: java.lang.String))(
        _.snapshotWindow
      )
      .optionallyWith(
        numShards.map(value => IntegerOptional.unwrap(value): Integer)
      )(_.numShards)
      .optionallyWith(
        shards.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.shards)
      .build()
  }
  def asReadOnly: zio.aws.memorydb.model.ClusterConfiguration.ReadOnly =
    zio.aws.memorydb.model.ClusterConfiguration.wrap(buildAwsValue())
}
object ClusterConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.memorydb.model.ClusterConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.memorydb.model.ClusterConfiguration =
      zio.aws.memorydb.model.ClusterConfiguration(
        name.map(value => value),
        description.map(value => value),
        nodeType.map(value => value),
        engineVersion.map(value => value),
        maintenanceWindow.map(value => value),
        topicArn.map(value => value),
        port.map(value => value),
        parameterGroupName.map(value => value),
        subnetGroupName.map(value => value),
        vpcId.map(value => value),
        snapshotRetentionLimit.map(value => value),
        snapshotWindow.map(value => value),
        numShards.map(value => value),
        shards.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def name: Option[String]
    def description: Option[String]
    def nodeType: Option[String]
    def engineVersion: Option[String]
    def maintenanceWindow: Option[String]
    def topicArn: Option[String]
    def port: Option[IntegerOptional]
    def parameterGroupName: Option[String]
    def subnetGroupName: Option[String]
    def vpcId: Option[String]
    def snapshotRetentionLimit: Option[IntegerOptional]
    def snapshotWindow: Option[String]
    def numShards: Option[IntegerOptional]
    def shards: Option[List[zio.aws.memorydb.model.ShardDetail.ReadOnly]]
    def getName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("name", name)
    def getDescription: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("description", description)
    def getNodeType: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nodeType", nodeType)
    def getEngineVersion: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("engineVersion", engineVersion)
    def getMaintenanceWindow: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("maintenanceWindow", maintenanceWindow)
    def getTopicArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("topicArn", topicArn)
    def getPort: ZIO[Any, AwsError, IntegerOptional] =
      AwsError.unwrapOptionField("port", port)
    def getParameterGroupName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("parameterGroupName", parameterGroupName)
    def getSubnetGroupName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("subnetGroupName", subnetGroupName)
    def getVpcId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("vpcId", vpcId)
    def getSnapshotRetentionLimit: ZIO[Any, AwsError, IntegerOptional] =
      AwsError.unwrapOptionField(
        "snapshotRetentionLimit",
        snapshotRetentionLimit
      )
    def getSnapshotWindow: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("snapshotWindow", snapshotWindow)
    def getNumShards: ZIO[Any, AwsError, IntegerOptional] =
      AwsError.unwrapOptionField("numShards", numShards)
    def getShards: ZIO[Any, AwsError, List[
      zio.aws.memorydb.model.ShardDetail.ReadOnly
    ]] = AwsError.unwrapOptionField("shards", shards)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.memorydb.model.ClusterConfiguration
  ) extends zio.aws.memorydb.model.ClusterConfiguration.ReadOnly {
    override val name: Option[String] =
      scala.Option(impl.name()).map(value => value: String)
    override val description: Option[String] =
      scala.Option(impl.description()).map(value => value: String)
    override val nodeType: Option[String] =
      scala.Option(impl.nodeType()).map(value => value: String)
    override val engineVersion: Option[String] =
      scala.Option(impl.engineVersion()).map(value => value: String)
    override val maintenanceWindow: Option[String] =
      scala.Option(impl.maintenanceWindow()).map(value => value: String)
    override val topicArn: Option[String] =
      scala.Option(impl.topicArn()).map(value => value: String)
    override val port: Option[IntegerOptional] = scala
      .Option(impl.port())
      .map(value => zio.aws.memorydb.model.primitives.IntegerOptional(value))
    override val parameterGroupName: Option[String] =
      scala.Option(impl.parameterGroupName()).map(value => value: String)
    override val subnetGroupName: Option[String] =
      scala.Option(impl.subnetGroupName()).map(value => value: String)
    override val vpcId: Option[String] =
      scala.Option(impl.vpcId()).map(value => value: String)
    override val snapshotRetentionLimit: Option[IntegerOptional] = scala
      .Option(impl.snapshotRetentionLimit())
      .map(value => zio.aws.memorydb.model.primitives.IntegerOptional(value))
    override val snapshotWindow: Option[String] =
      scala.Option(impl.snapshotWindow()).map(value => value: String)
    override val numShards: Option[IntegerOptional] = scala
      .Option(impl.numShards())
      .map(value => zio.aws.memorydb.model.primitives.IntegerOptional(value))
    override val shards
        : Option[List[zio.aws.memorydb.model.ShardDetail.ReadOnly]] = scala
      .Option(impl.shards())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.memorydb.model.ShardDetail.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.memorydb.model.ClusterConfiguration
  ): zio.aws.memorydb.model.ClusterConfiguration.ReadOnly = new Wrapper(impl)
}
