package zio.aws.memorydb.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class UpdateSubnetGroupResponse(
    subnetGroup: Option[zio.aws.memorydb.model.SubnetGroup] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.memorydb.model.UpdateSubnetGroupResponse = {
    import UpdateSubnetGroupResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.memorydb.model.UpdateSubnetGroupResponse
      .builder()
      .optionallyWith(subnetGroup.map(value => value.buildAwsValue()))(
        _.subnetGroup
      )
      .build()
  }
  def asReadOnly: zio.aws.memorydb.model.UpdateSubnetGroupResponse.ReadOnly =
    zio.aws.memorydb.model.UpdateSubnetGroupResponse.wrap(buildAwsValue())
}
object UpdateSubnetGroupResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.memorydb.model.UpdateSubnetGroupResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.memorydb.model.UpdateSubnetGroupResponse =
      zio.aws.memorydb.model
        .UpdateSubnetGroupResponse(subnetGroup.map(value => value.asEditable))
    def subnetGroup: Option[zio.aws.memorydb.model.SubnetGroup.ReadOnly]
    def getSubnetGroup
        : ZIO[Any, AwsError, zio.aws.memorydb.model.SubnetGroup.ReadOnly] =
      AwsError.unwrapOptionField("subnetGroup", subnetGroup)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.memorydb.model.UpdateSubnetGroupResponse
  ) extends zio.aws.memorydb.model.UpdateSubnetGroupResponse.ReadOnly {
    override val subnetGroup
        : Option[zio.aws.memorydb.model.SubnetGroup.ReadOnly] = scala
      .Option(impl.subnetGroup())
      .map(value => zio.aws.memorydb.model.SubnetGroup.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.memorydb.model.UpdateSubnetGroupResponse
  ): zio.aws.memorydb.model.UpdateSubnetGroupResponse.ReadOnly = new Wrapper(
    impl
  )
}
