package zio.aws.memorydb.model
import java.lang.Integer
import zio.ZIO
import zio.aws.memorydb.model.primitives.IntegerOptional
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ShardConfiguration(
    slots: Option[String] = None,
    replicaCount: Option[IntegerOptional] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.memorydb.model.ShardConfiguration = {
    import ShardConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.memorydb.model.ShardConfiguration
      .builder()
      .optionallyWith(slots.map(value => value: java.lang.String))(_.slots)
      .optionallyWith(
        replicaCount.map(value => IntegerOptional.unwrap(value): Integer)
      )(_.replicaCount)
      .build()
  }
  def asReadOnly: zio.aws.memorydb.model.ShardConfiguration.ReadOnly =
    zio.aws.memorydb.model.ShardConfiguration.wrap(buildAwsValue())
}
object ShardConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.memorydb.model.ShardConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.memorydb.model.ShardConfiguration =
      zio.aws.memorydb.model.ShardConfiguration(
        slots.map(value => value),
        replicaCount.map(value => value)
      )
    def slots: Option[String]
    def replicaCount: Option[IntegerOptional]
    def getSlots: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("slots", slots)
    def getReplicaCount: ZIO[Any, AwsError, IntegerOptional] =
      AwsError.unwrapOptionField("replicaCount", replicaCount)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.memorydb.model.ShardConfiguration
  ) extends zio.aws.memorydb.model.ShardConfiguration.ReadOnly {
    override val slots: Option[String] =
      scala.Option(impl.slots()).map(value => value: String)
    override val replicaCount: Option[IntegerOptional] = scala
      .Option(impl.replicaCount())
      .map(value => zio.aws.memorydb.model.primitives.IntegerOptional(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.memorydb.model.ShardConfiguration
  ): zio.aws.memorydb.model.ShardConfiguration.ReadOnly = new Wrapper(impl)
}
