package zio.aws.memorydb.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class SecurityGroupMembership(
    securityGroupId: Option[String] = None,
    status: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.memorydb.model.SecurityGroupMembership = {
    import SecurityGroupMembership.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.memorydb.model.SecurityGroupMembership
      .builder()
      .optionallyWith(securityGroupId.map(value => value: java.lang.String))(
        _.securityGroupId
      )
      .optionallyWith(status.map(value => value: java.lang.String))(_.status)
      .build()
  }
  def asReadOnly: zio.aws.memorydb.model.SecurityGroupMembership.ReadOnly =
    zio.aws.memorydb.model.SecurityGroupMembership.wrap(buildAwsValue())
}
object SecurityGroupMembership {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.memorydb.model.SecurityGroupMembership
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.memorydb.model.SecurityGroupMembership =
      zio.aws.memorydb.model.SecurityGroupMembership(
        securityGroupId.map(value => value),
        status.map(value => value)
      )
    def securityGroupId: Option[String]
    def status: Option[String]
    def getSecurityGroupId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("securityGroupId", securityGroupId)
    def getStatus: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("status", status)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.memorydb.model.SecurityGroupMembership
  ) extends zio.aws.memorydb.model.SecurityGroupMembership.ReadOnly {
    override val securityGroupId: Option[String] =
      scala.Option(impl.securityGroupId()).map(value => value: String)
    override val status: Option[String] =
      scala.Option(impl.status()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.memorydb.model.SecurityGroupMembership
  ): zio.aws.memorydb.model.SecurityGroupMembership.ReadOnly = new Wrapper(impl)
}
