package zio.aws.memorydb.model
import zio.ZIO
import zio.aws.memorydb.model.primitives.TStamp
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import scala.jdk.CollectionConverters._
final case class Node(
    name: Option[String] = None,
    status: Option[String] = None,
    availabilityZone: Option[String] = None,
    createTime: Option[TStamp] = None,
    endpoint: Option[zio.aws.memorydb.model.Endpoint] = None
) {
  def buildAwsValue(): software.amazon.awssdk.services.memorydb.model.Node = {
    import Node.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.memorydb.model.Node
      .builder()
      .optionallyWith(name.map(value => value: java.lang.String))(_.name)
      .optionallyWith(status.map(value => value: java.lang.String))(_.status)
      .optionallyWith(availabilityZone.map(value => value: java.lang.String))(
        _.availabilityZone
      )
      .optionallyWith(createTime.map(value => TStamp.unwrap(value): Instant))(
        _.createTime
      )
      .optionallyWith(endpoint.map(value => value.buildAwsValue()))(_.endpoint)
      .build()
  }
  def asReadOnly: zio.aws.memorydb.model.Node.ReadOnly =
    zio.aws.memorydb.model.Node.wrap(buildAwsValue())
}
object Node {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.memorydb.model.Node] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.memorydb.model.Node = zio.aws.memorydb.model.Node(
      name.map(value => value),
      status.map(value => value),
      availabilityZone.map(value => value),
      createTime.map(value => value),
      endpoint.map(value => value.asEditable)
    )
    def name: Option[String]
    def status: Option[String]
    def availabilityZone: Option[String]
    def createTime: Option[TStamp]
    def endpoint: Option[zio.aws.memorydb.model.Endpoint.ReadOnly]
    def getName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("name", name)
    def getStatus: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("status", status)
    def getAvailabilityZone: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("availabilityZone", availabilityZone)
    def getCreateTime: ZIO[Any, AwsError, TStamp] =
      AwsError.unwrapOptionField("createTime", createTime)
    def getEndpoint
        : ZIO[Any, AwsError, zio.aws.memorydb.model.Endpoint.ReadOnly] =
      AwsError.unwrapOptionField("endpoint", endpoint)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.memorydb.model.Node
  ) extends zio.aws.memorydb.model.Node.ReadOnly {
    override val name: Option[String] =
      scala.Option(impl.name()).map(value => value: String)
    override val status: Option[String] =
      scala.Option(impl.status()).map(value => value: String)
    override val availabilityZone: Option[String] =
      scala.Option(impl.availabilityZone()).map(value => value: String)
    override val createTime: Option[TStamp] = scala
      .Option(impl.createTime())
      .map(value => zio.aws.memorydb.model.primitives.TStamp(value))
    override val endpoint: Option[zio.aws.memorydb.model.Endpoint.ReadOnly] =
      scala
        .Option(impl.endpoint())
        .map(value => zio.aws.memorydb.model.Endpoint.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.memorydb.model.Node
  ): zio.aws.memorydb.model.Node.ReadOnly = new Wrapper(impl)
}
