package zio.aws.memorydb.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class UpdateSubnetGroupRequest(
    subnetGroupName: String,
    description: Option[String] = None,
    subnetIds: Option[Iterable[String]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.memorydb.model.UpdateSubnetGroupRequest = {
    import UpdateSubnetGroupRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.memorydb.model.UpdateSubnetGroupRequest
      .builder()
      .subnetGroupName(subnetGroupName: java.lang.String)
      .optionallyWith(description.map(value => value: java.lang.String))(
        _.description
      )
      .optionallyWith(
        subnetIds.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.subnetIds)
      .build()
  }
  def asReadOnly: zio.aws.memorydb.model.UpdateSubnetGroupRequest.ReadOnly =
    zio.aws.memorydb.model.UpdateSubnetGroupRequest.wrap(buildAwsValue())
}
object UpdateSubnetGroupRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.memorydb.model.UpdateSubnetGroupRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.memorydb.model.UpdateSubnetGroupRequest =
      zio.aws.memorydb.model.UpdateSubnetGroupRequest(
        subnetGroupName,
        description.map(value => value),
        subnetIds.map(value => value)
      )
    def subnetGroupName: String
    def description: Option[String]
    def subnetIds: Option[List[String]]
    def getSubnetGroupName: ZIO[Any, Nothing, String] =
      ZIO.succeed(subnetGroupName)
    def getDescription: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("description", description)
    def getSubnetIds: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("subnetIds", subnetIds)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.memorydb.model.UpdateSubnetGroupRequest
  ) extends zio.aws.memorydb.model.UpdateSubnetGroupRequest.ReadOnly {
    override val subnetGroupName: String = impl.subnetGroupName(): String
    override val description: Option[String] =
      scala.Option(impl.description()).map(value => value: String)
    override val subnetIds: Option[List[String]] = scala
      .Option(impl.subnetIds())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.memorydb.model.UpdateSubnetGroupRequest
  ): zio.aws.memorydb.model.UpdateSubnetGroupRequest.ReadOnly = new Wrapper(
    impl
  )
}
