package zio.aws.memorydb.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ResetParameterGroupResponse(
    parameterGroup: Option[zio.aws.memorydb.model.ParameterGroup] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.memorydb.model.ResetParameterGroupResponse = {
    import ResetParameterGroupResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.memorydb.model.ResetParameterGroupResponse
      .builder()
      .optionallyWith(parameterGroup.map(value => value.buildAwsValue()))(
        _.parameterGroup
      )
      .build()
  }
  def asReadOnly: zio.aws.memorydb.model.ResetParameterGroupResponse.ReadOnly =
    zio.aws.memorydb.model.ResetParameterGroupResponse.wrap(buildAwsValue())
}
object ResetParameterGroupResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.memorydb.model.ResetParameterGroupResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.memorydb.model.ResetParameterGroupResponse =
      zio.aws.memorydb.model.ResetParameterGroupResponse(
        parameterGroup.map(value => value.asEditable)
      )
    def parameterGroup: Option[zio.aws.memorydb.model.ParameterGroup.ReadOnly]
    def getParameterGroup
        : ZIO[Any, AwsError, zio.aws.memorydb.model.ParameterGroup.ReadOnly] =
      AwsError.unwrapOptionField("parameterGroup", parameterGroup)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.memorydb.model.ResetParameterGroupResponse
  ) extends zio.aws.memorydb.model.ResetParameterGroupResponse.ReadOnly {
    override val parameterGroup
        : Option[zio.aws.memorydb.model.ParameterGroup.ReadOnly] = scala
      .Option(impl.parameterGroup())
      .map(value => zio.aws.memorydb.model.ParameterGroup.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.memorydb.model.ResetParameterGroupResponse
  ): zio.aws.memorydb.model.ResetParameterGroupResponse.ReadOnly = new Wrapper(
    impl
  )
}
