package zio.aws.memorydb.model
import zio.ZIO
import zio.aws.memorydb.model.primitives.UserName
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ACL(
    name: Option[String] = None,
    status: Option[String] = None,
    userNames: Option[Iterable[UserName]] = None,
    minimumEngineVersion: Option[String] = None,
    pendingChanges: Option[zio.aws.memorydb.model.ACLPendingChanges] = None,
    clusters: Option[Iterable[String]] = None,
    arn: Option[String] = None
) {
  def buildAwsValue(): software.amazon.awssdk.services.memorydb.model.ACL = {
    import ACL.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.memorydb.model.ACL
      .builder()
      .optionallyWith(name.map(value => value: java.lang.String))(_.name)
      .optionallyWith(status.map(value => value: java.lang.String))(_.status)
      .optionallyWith(
        userNames.map(value =>
          value.map { item =>
            UserName.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.userNames)
      .optionallyWith(
        minimumEngineVersion.map(value => value: java.lang.String)
      )(_.minimumEngineVersion)
      .optionallyWith(pendingChanges.map(value => value.buildAwsValue()))(
        _.pendingChanges
      )
      .optionallyWith(
        clusters.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.clusters)
      .optionallyWith(arn.map(value => value: java.lang.String))(_.arn)
      .build()
  }
  def asReadOnly: zio.aws.memorydb.model.ACL.ReadOnly =
    zio.aws.memorydb.model.ACL.wrap(buildAwsValue())
}
object ACL {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.memorydb.model.ACL] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.memorydb.model.ACL = zio.aws.memorydb.model.ACL(
      name.map(value => value),
      status.map(value => value),
      userNames.map(value => value),
      minimumEngineVersion.map(value => value),
      pendingChanges.map(value => value.asEditable),
      clusters.map(value => value),
      arn.map(value => value)
    )
    def name: Option[String]
    def status: Option[String]
    def userNames: Option[List[UserName]]
    def minimumEngineVersion: Option[String]
    def pendingChanges
        : Option[zio.aws.memorydb.model.ACLPendingChanges.ReadOnly]
    def clusters: Option[List[String]]
    def arn: Option[String]
    def getName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("name", name)
    def getStatus: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("status", status)
    def getUserNames: ZIO[Any, AwsError, List[UserName]] =
      AwsError.unwrapOptionField("userNames", userNames)
    def getMinimumEngineVersion: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("minimumEngineVersion", minimumEngineVersion)
    def getPendingChanges: ZIO[
      Any,
      AwsError,
      zio.aws.memorydb.model.ACLPendingChanges.ReadOnly
    ] = AwsError.unwrapOptionField("pendingChanges", pendingChanges)
    def getClusters: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("clusters", clusters)
    def getArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("arn", arn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.memorydb.model.ACL
  ) extends zio.aws.memorydb.model.ACL.ReadOnly {
    override val name: Option[String] =
      scala.Option(impl.name()).map(value => value: String)
    override val status: Option[String] =
      scala.Option(impl.status()).map(value => value: String)
    override val userNames: Option[List[UserName]] = scala
      .Option(impl.userNames())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.memorydb.model.primitives.UserName(item)
        }.toList
      )
    override val minimumEngineVersion: Option[String] =
      scala.Option(impl.minimumEngineVersion()).map(value => value: String)
    override val pendingChanges
        : Option[zio.aws.memorydb.model.ACLPendingChanges.ReadOnly] = scala
      .Option(impl.pendingChanges())
      .map(value => zio.aws.memorydb.model.ACLPendingChanges.wrap(value))
    override val clusters: Option[List[String]] = scala
      .Option(impl.clusters())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
    override val arn: Option[String] =
      scala.Option(impl.arn()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.memorydb.model.ACL
  ): zio.aws.memorydb.model.ACL.ReadOnly = new Wrapper(impl)
}
