package zio.aws.memorydb.model
import zio.ZIO
import zio.aws.memorydb.model.primitives.ACLName
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class User(
    name: Option[String] = None,
    status: Option[String] = None,
    accessString: Option[String] = None,
    aclNames: Option[Iterable[ACLName]] = None,
    minimumEngineVersion: Option[String] = None,
    authentication: Option[zio.aws.memorydb.model.Authentication] = None,
    arn: Option[String] = None
) {
  def buildAwsValue(): software.amazon.awssdk.services.memorydb.model.User = {
    import User.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.memorydb.model.User
      .builder()
      .optionallyWith(name.map(value => value: java.lang.String))(_.name)
      .optionallyWith(status.map(value => value: java.lang.String))(_.status)
      .optionallyWith(accessString.map(value => value: java.lang.String))(
        _.accessString
      )
      .optionallyWith(
        aclNames.map(value =>
          value.map { item =>
            ACLName.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.aclNames)
      .optionallyWith(
        minimumEngineVersion.map(value => value: java.lang.String)
      )(_.minimumEngineVersion)
      .optionallyWith(authentication.map(value => value.buildAwsValue()))(
        _.authentication
      )
      .optionallyWith(arn.map(value => value: java.lang.String))(_.arn)
      .build()
  }
  def asReadOnly: zio.aws.memorydb.model.User.ReadOnly =
    zio.aws.memorydb.model.User.wrap(buildAwsValue())
}
object User {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.memorydb.model.User] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.memorydb.model.User = zio.aws.memorydb.model.User(
      name.map(value => value),
      status.map(value => value),
      accessString.map(value => value),
      aclNames.map(value => value),
      minimumEngineVersion.map(value => value),
      authentication.map(value => value.asEditable),
      arn.map(value => value)
    )
    def name: Option[String]
    def status: Option[String]
    def accessString: Option[String]
    def aclNames: Option[List[ACLName]]
    def minimumEngineVersion: Option[String]
    def authentication: Option[zio.aws.memorydb.model.Authentication.ReadOnly]
    def arn: Option[String]
    def getName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("name", name)
    def getStatus: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("status", status)
    def getAccessString: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("accessString", accessString)
    def getAclNames: ZIO[Any, AwsError, List[ACLName]] =
      AwsError.unwrapOptionField("aclNames", aclNames)
    def getMinimumEngineVersion: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("minimumEngineVersion", minimumEngineVersion)
    def getAuthentication
        : ZIO[Any, AwsError, zio.aws.memorydb.model.Authentication.ReadOnly] =
      AwsError.unwrapOptionField("authentication", authentication)
    def getArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("arn", arn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.memorydb.model.User
  ) extends zio.aws.memorydb.model.User.ReadOnly {
    override val name: Option[String] =
      scala.Option(impl.name()).map(value => value: String)
    override val status: Option[String] =
      scala.Option(impl.status()).map(value => value: String)
    override val accessString: Option[String] =
      scala.Option(impl.accessString()).map(value => value: String)
    override val aclNames: Option[List[ACLName]] = scala
      .Option(impl.aclNames())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.memorydb.model.primitives.ACLName(item)
        }.toList
      )
    override val minimumEngineVersion: Option[String] =
      scala.Option(impl.minimumEngineVersion()).map(value => value: String)
    override val authentication
        : Option[zio.aws.memorydb.model.Authentication.ReadOnly] = scala
      .Option(impl.authentication())
      .map(value => zio.aws.memorydb.model.Authentication.wrap(value))
    override val arn: Option[String] =
      scala.Option(impl.arn()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.memorydb.model.User
  ): zio.aws.memorydb.model.User.ReadOnly = new Wrapper(impl)
}
