package zio.aws.memorydb.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class SubnetGroup(
    name: Option[String] = None,
    description: Option[String] = None,
    vpcId: Option[String] = None,
    subnets: Option[Iterable[zio.aws.memorydb.model.Subnet]] = None,
    arn: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.memorydb.model.SubnetGroup = {
    import SubnetGroup.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.memorydb.model.SubnetGroup
      .builder()
      .optionallyWith(name.map(value => value: java.lang.String))(_.name)
      .optionallyWith(description.map(value => value: java.lang.String))(
        _.description
      )
      .optionallyWith(vpcId.map(value => value: java.lang.String))(_.vpcId)
      .optionallyWith(
        subnets.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.subnets)
      .optionallyWith(arn.map(value => value: java.lang.String))(_.arn)
      .build()
  }
  def asReadOnly: zio.aws.memorydb.model.SubnetGroup.ReadOnly =
    zio.aws.memorydb.model.SubnetGroup.wrap(buildAwsValue())
}
object SubnetGroup {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.memorydb.model.SubnetGroup
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.memorydb.model.SubnetGroup =
      zio.aws.memorydb.model.SubnetGroup(
        name.map(value => value),
        description.map(value => value),
        vpcId.map(value => value),
        subnets.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        arn.map(value => value)
      )
    def name: Option[String]
    def description: Option[String]
    def vpcId: Option[String]
    def subnets: Option[List[zio.aws.memorydb.model.Subnet.ReadOnly]]
    def arn: Option[String]
    def getName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("name", name)
    def getDescription: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("description", description)
    def getVpcId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("vpcId", vpcId)
    def getSubnets
        : ZIO[Any, AwsError, List[zio.aws.memorydb.model.Subnet.ReadOnly]] =
      AwsError.unwrapOptionField("subnets", subnets)
    def getArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("arn", arn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.memorydb.model.SubnetGroup
  ) extends zio.aws.memorydb.model.SubnetGroup.ReadOnly {
    override val name: Option[String] =
      scala.Option(impl.name()).map(value => value: String)
    override val description: Option[String] =
      scala.Option(impl.description()).map(value => value: String)
    override val vpcId: Option[String] =
      scala.Option(impl.vpcId()).map(value => value: String)
    override val subnets: Option[List[zio.aws.memorydb.model.Subnet.ReadOnly]] =
      scala
        .Option(impl.subnets())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.memorydb.model.Subnet.wrap(item)
          }.toList
        )
    override val arn: Option[String] =
      scala.Option(impl.arn()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.memorydb.model.SubnetGroup
  ): zio.aws.memorydb.model.SubnetGroup.ReadOnly = new Wrapper(impl)
}
