package zio.aws.memorydb.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class Subnet(
    identifier: Option[String] = None,
    availabilityZone: Option[zio.aws.memorydb.model.AvailabilityZone] = None
) {
  def buildAwsValue(): software.amazon.awssdk.services.memorydb.model.Subnet = {
    import Subnet.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.memorydb.model.Subnet
      .builder()
      .optionallyWith(identifier.map(value => value: java.lang.String))(
        _.identifier
      )
      .optionallyWith(availabilityZone.map(value => value.buildAwsValue()))(
        _.availabilityZone
      )
      .build()
  }
  def asReadOnly: zio.aws.memorydb.model.Subnet.ReadOnly =
    zio.aws.memorydb.model.Subnet.wrap(buildAwsValue())
}
object Subnet {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.memorydb.model.Subnet] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.memorydb.model.Subnet =
      zio.aws.memorydb.model.Subnet(
        identifier.map(value => value),
        availabilityZone.map(value => value.asEditable)
      )
    def identifier: Option[String]
    def availabilityZone
        : Option[zio.aws.memorydb.model.AvailabilityZone.ReadOnly]
    def getIdentifier: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("identifier", identifier)
    def getAvailabilityZone
        : ZIO[Any, AwsError, zio.aws.memorydb.model.AvailabilityZone.ReadOnly] =
      AwsError.unwrapOptionField("availabilityZone", availabilityZone)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.memorydb.model.Subnet
  ) extends zio.aws.memorydb.model.Subnet.ReadOnly {
    override val identifier: Option[String] =
      scala.Option(impl.identifier()).map(value => value: String)
    override val availabilityZone
        : Option[zio.aws.memorydb.model.AvailabilityZone.ReadOnly] = scala
      .Option(impl.availabilityZone())
      .map(value => zio.aws.memorydb.model.AvailabilityZone.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.memorydb.model.Subnet
  ): zio.aws.memorydb.model.Subnet.ReadOnly = new Wrapper(impl)
}
