package zio.aws.memorydb.model
import java.lang.Integer
import zio.ZIO
import zio.aws.memorydb.model.primitives.IntegerOptional
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class DescribeAcLsRequest(
    aclName: Option[String] = None,
    maxResults: Option[IntegerOptional] = None,
    nextToken: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.memorydb.model.DescribeAcLsRequest = {
    import DescribeAcLsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.memorydb.model.DescribeAcLsRequest
      .builder()
      .optionallyWith(aclName.map(value => value: java.lang.String))(_.aclName)
      .optionallyWith(
        maxResults.map(value => IntegerOptional.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .build()
  }
  def asReadOnly: zio.aws.memorydb.model.DescribeAcLsRequest.ReadOnly =
    zio.aws.memorydb.model.DescribeAcLsRequest.wrap(buildAwsValue())
}
object DescribeAcLsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.memorydb.model.DescribeAcLsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.memorydb.model.DescribeAcLsRequest =
      zio.aws.memorydb.model.DescribeAcLsRequest(
        aclName.map(value => value),
        maxResults.map(value => value),
        nextToken.map(value => value)
      )
    def aclName: Option[String]
    def maxResults: Option[IntegerOptional]
    def nextToken: Option[String]
    def getAclName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("aclName", aclName)
    def getMaxResults: ZIO[Any, AwsError, IntegerOptional] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.memorydb.model.DescribeAcLsRequest
  ) extends zio.aws.memorydb.model.DescribeAcLsRequest.ReadOnly {
    override val aclName: Option[String] =
      scala.Option(impl.aclName()).map(value => value: String)
    override val maxResults: Option[IntegerOptional] = scala
      .Option(impl.maxResults())
      .map(value => zio.aws.memorydb.model.primitives.IntegerOptional(value))
    override val nextToken: Option[String] =
      scala.Option(impl.nextToken()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.memorydb.model.DescribeAcLsRequest
  ): zio.aws.memorydb.model.DescribeAcLsRequest.ReadOnly = new Wrapper(impl)
}
