package zio.aws.memorydb.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class DescribeSubnetGroupsResponse(
    nextToken: Option[String] = None,
    subnetGroups: Option[Iterable[zio.aws.memorydb.model.SubnetGroup]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.memorydb.model.DescribeSubnetGroupsResponse = {
    import DescribeSubnetGroupsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.memorydb.model.DescribeSubnetGroupsResponse
      .builder()
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .optionallyWith(
        subnetGroups.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.subnetGroups)
      .build()
  }
  def asReadOnly: zio.aws.memorydb.model.DescribeSubnetGroupsResponse.ReadOnly =
    zio.aws.memorydb.model.DescribeSubnetGroupsResponse.wrap(buildAwsValue())
}
object DescribeSubnetGroupsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.memorydb.model.DescribeSubnetGroupsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.memorydb.model.DescribeSubnetGroupsResponse =
      zio.aws.memorydb.model.DescribeSubnetGroupsResponse(
        nextToken.map(value => value),
        subnetGroups.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def nextToken: Option[String]
    def subnetGroups: Option[List[zio.aws.memorydb.model.SubnetGroup.ReadOnly]]
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getSubnetGroups: ZIO[Any, AwsError, List[
      zio.aws.memorydb.model.SubnetGroup.ReadOnly
    ]] = AwsError.unwrapOptionField("subnetGroups", subnetGroups)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.memorydb.model.DescribeSubnetGroupsResponse
  ) extends zio.aws.memorydb.model.DescribeSubnetGroupsResponse.ReadOnly {
    override val nextToken: Option[String] =
      scala.Option(impl.nextToken()).map(value => value: String)
    override val subnetGroups
        : Option[List[zio.aws.memorydb.model.SubnetGroup.ReadOnly]] = scala
      .Option(impl.subnetGroups())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.memorydb.model.SubnetGroup.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.memorydb.model.DescribeSubnetGroupsResponse
  ): zio.aws.memorydb.model.DescribeSubnetGroupsResponse.ReadOnly = new Wrapper(
    impl
  )
}
