package zio.aws.memorydb.model
import java.lang.Integer
import zio.ZIO
import zio.aws.memorydb.model.primitives.{
  ACLName,
  BooleanOptional,
  IntegerOptional
}
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class CreateClusterRequest(
    clusterName: String,
    nodeType: String,
    parameterGroupName: Option[String] = None,
    description: Option[String] = None,
    numShards: Option[IntegerOptional] = None,
    numReplicasPerShard: Option[IntegerOptional] = None,
    subnetGroupName: Option[String] = None,
    securityGroupIds: Option[Iterable[String]] = None,
    maintenanceWindow: Option[String] = None,
    port: Option[IntegerOptional] = None,
    snsTopicArn: Option[String] = None,
    tlsEnabled: Option[BooleanOptional] = None,
    kmsKeyId: Option[String] = None,
    snapshotArns: Option[Iterable[String]] = None,
    snapshotName: Option[String] = None,
    snapshotRetentionLimit: Option[IntegerOptional] = None,
    tags: Option[Iterable[zio.aws.memorydb.model.Tag]] = None,
    snapshotWindow: Option[String] = None,
    aclName: ACLName,
    engineVersion: Option[String] = None,
    autoMinorVersionUpgrade: Option[BooleanOptional] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.memorydb.model.CreateClusterRequest = {
    import CreateClusterRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.memorydb.model.CreateClusterRequest
      .builder()
      .clusterName(clusterName: java.lang.String)
      .nodeType(nodeType: java.lang.String)
      .optionallyWith(parameterGroupName.map(value => value: java.lang.String))(
        _.parameterGroupName
      )
      .optionallyWith(description.map(value => value: java.lang.String))(
        _.description
      )
      .optionallyWith(
        numShards.map(value => IntegerOptional.unwrap(value): Integer)
      )(_.numShards)
      .optionallyWith(
        numReplicasPerShard.map(value => IntegerOptional.unwrap(value): Integer)
      )(_.numReplicasPerShard)
      .optionallyWith(subnetGroupName.map(value => value: java.lang.String))(
        _.subnetGroupName
      )
      .optionallyWith(
        securityGroupIds.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.securityGroupIds)
      .optionallyWith(maintenanceWindow.map(value => value: java.lang.String))(
        _.maintenanceWindow
      )
      .optionallyWith(
        port.map(value => IntegerOptional.unwrap(value): Integer)
      )(_.port)
      .optionallyWith(snsTopicArn.map(value => value: java.lang.String))(
        _.snsTopicArn
      )
      .optionallyWith(
        tlsEnabled.map(value =>
          BooleanOptional.unwrap(value): java.lang.Boolean
        )
      )(_.tlsEnabled)
      .optionallyWith(kmsKeyId.map(value => value: java.lang.String))(
        _.kmsKeyId
      )
      .optionallyWith(
        snapshotArns.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.snapshotArns)
      .optionallyWith(snapshotName.map(value => value: java.lang.String))(
        _.snapshotName
      )
      .optionallyWith(
        snapshotRetentionLimit.map(value =>
          IntegerOptional.unwrap(value): Integer
        )
      )(_.snapshotRetentionLimit)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .optionallyWith(snapshotWindow.map(value => value: java.lang.String))(
        _.snapshotWindow
      )
      .aclName(ACLName.unwrap(aclName): java.lang.String)
      .optionallyWith(engineVersion.map(value => value: java.lang.String))(
        _.engineVersion
      )
      .optionallyWith(
        autoMinorVersionUpgrade.map(value =>
          BooleanOptional.unwrap(value): java.lang.Boolean
        )
      )(_.autoMinorVersionUpgrade)
      .build()
  }
  def asReadOnly: zio.aws.memorydb.model.CreateClusterRequest.ReadOnly =
    zio.aws.memorydb.model.CreateClusterRequest.wrap(buildAwsValue())
}
object CreateClusterRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.memorydb.model.CreateClusterRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.memorydb.model.CreateClusterRequest =
      zio.aws.memorydb.model.CreateClusterRequest(
        clusterName,
        nodeType,
        parameterGroupName.map(value => value),
        description.map(value => value),
        numShards.map(value => value),
        numReplicasPerShard.map(value => value),
        subnetGroupName.map(value => value),
        securityGroupIds.map(value => value),
        maintenanceWindow.map(value => value),
        port.map(value => value),
        snsTopicArn.map(value => value),
        tlsEnabled.map(value => value),
        kmsKeyId.map(value => value),
        snapshotArns.map(value => value),
        snapshotName.map(value => value),
        snapshotRetentionLimit.map(value => value),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        snapshotWindow.map(value => value),
        aclName,
        engineVersion.map(value => value),
        autoMinorVersionUpgrade.map(value => value)
      )
    def clusterName: String
    def nodeType: String
    def parameterGroupName: Option[String]
    def description: Option[String]
    def numShards: Option[IntegerOptional]
    def numReplicasPerShard: Option[IntegerOptional]
    def subnetGroupName: Option[String]
    def securityGroupIds: Option[List[String]]
    def maintenanceWindow: Option[String]
    def port: Option[IntegerOptional]
    def snsTopicArn: Option[String]
    def tlsEnabled: Option[BooleanOptional]
    def kmsKeyId: Option[String]
    def snapshotArns: Option[List[String]]
    def snapshotName: Option[String]
    def snapshotRetentionLimit: Option[IntegerOptional]
    def tags: Option[List[zio.aws.memorydb.model.Tag.ReadOnly]]
    def snapshotWindow: Option[String]
    def aclName: ACLName
    def engineVersion: Option[String]
    def autoMinorVersionUpgrade: Option[BooleanOptional]
    def getClusterName: ZIO[Any, Nothing, String] = ZIO.succeed(clusterName)
    def getNodeType: ZIO[Any, Nothing, String] = ZIO.succeed(nodeType)
    def getParameterGroupName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("parameterGroupName", parameterGroupName)
    def getDescription: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("description", description)
    def getNumShards: ZIO[Any, AwsError, IntegerOptional] =
      AwsError.unwrapOptionField("numShards", numShards)
    def getNumReplicasPerShard: ZIO[Any, AwsError, IntegerOptional] =
      AwsError.unwrapOptionField("numReplicasPerShard", numReplicasPerShard)
    def getSubnetGroupName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("subnetGroupName", subnetGroupName)
    def getSecurityGroupIds: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("securityGroupIds", securityGroupIds)
    def getMaintenanceWindow: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("maintenanceWindow", maintenanceWindow)
    def getPort: ZIO[Any, AwsError, IntegerOptional] =
      AwsError.unwrapOptionField("port", port)
    def getSnsTopicArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("snsTopicArn", snsTopicArn)
    def getTlsEnabled: ZIO[Any, AwsError, BooleanOptional] =
      AwsError.unwrapOptionField("tlsEnabled", tlsEnabled)
    def getKmsKeyId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("kmsKeyId", kmsKeyId)
    def getSnapshotArns: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("snapshotArns", snapshotArns)
    def getSnapshotName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("snapshotName", snapshotName)
    def getSnapshotRetentionLimit: ZIO[Any, AwsError, IntegerOptional] =
      AwsError.unwrapOptionField(
        "snapshotRetentionLimit",
        snapshotRetentionLimit
      )
    def getTags: ZIO[Any, AwsError, List[zio.aws.memorydb.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
    def getSnapshotWindow: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("snapshotWindow", snapshotWindow)
    def getAclName: ZIO[Any, Nothing, ACLName] = ZIO.succeed(aclName)
    def getEngineVersion: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("engineVersion", engineVersion)
    def getAutoMinorVersionUpgrade: ZIO[Any, AwsError, BooleanOptional] =
      AwsError.unwrapOptionField(
        "autoMinorVersionUpgrade",
        autoMinorVersionUpgrade
      )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.memorydb.model.CreateClusterRequest
  ) extends zio.aws.memorydb.model.CreateClusterRequest.ReadOnly {
    override val clusterName: String = impl.clusterName(): String
    override val nodeType: String = impl.nodeType(): String
    override val parameterGroupName: Option[String] =
      scala.Option(impl.parameterGroupName()).map(value => value: String)
    override val description: Option[String] =
      scala.Option(impl.description()).map(value => value: String)
    override val numShards: Option[IntegerOptional] = scala
      .Option(impl.numShards())
      .map(value => zio.aws.memorydb.model.primitives.IntegerOptional(value))
    override val numReplicasPerShard: Option[IntegerOptional] = scala
      .Option(impl.numReplicasPerShard())
      .map(value => zio.aws.memorydb.model.primitives.IntegerOptional(value))
    override val subnetGroupName: Option[String] =
      scala.Option(impl.subnetGroupName()).map(value => value: String)
    override val securityGroupIds: Option[List[String]] = scala
      .Option(impl.securityGroupIds())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
    override val maintenanceWindow: Option[String] =
      scala.Option(impl.maintenanceWindow()).map(value => value: String)
    override val port: Option[IntegerOptional] = scala
      .Option(impl.port())
      .map(value => zio.aws.memorydb.model.primitives.IntegerOptional(value))
    override val snsTopicArn: Option[String] =
      scala.Option(impl.snsTopicArn()).map(value => value: String)
    override val tlsEnabled: Option[BooleanOptional] = scala
      .Option(impl.tlsEnabled())
      .map(value => zio.aws.memorydb.model.primitives.BooleanOptional(value))
    override val kmsKeyId: Option[String] =
      scala.Option(impl.kmsKeyId()).map(value => value: String)
    override val snapshotArns: Option[List[String]] = scala
      .Option(impl.snapshotArns())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
    override val snapshotName: Option[String] =
      scala.Option(impl.snapshotName()).map(value => value: String)
    override val snapshotRetentionLimit: Option[IntegerOptional] = scala
      .Option(impl.snapshotRetentionLimit())
      .map(value => zio.aws.memorydb.model.primitives.IntegerOptional(value))
    override val tags: Option[List[zio.aws.memorydb.model.Tag.ReadOnly]] = scala
      .Option(impl.tags())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.memorydb.model.Tag.wrap(item)
        }.toList
      )
    override val snapshotWindow: Option[String] =
      scala.Option(impl.snapshotWindow()).map(value => value: String)
    override val aclName: ACLName =
      zio.aws.memorydb.model.primitives.ACLName(impl.aclName())
    override val engineVersion: Option[String] =
      scala.Option(impl.engineVersion()).map(value => value: String)
    override val autoMinorVersionUpgrade: Option[BooleanOptional] = scala
      .Option(impl.autoMinorVersionUpgrade())
      .map(value => zio.aws.memorydb.model.primitives.BooleanOptional(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.memorydb.model.CreateClusterRequest
  ): zio.aws.memorydb.model.CreateClusterRequest.ReadOnly = new Wrapper(impl)
}
