package zio.aws.mediatailor.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class UpdateProgramScheduleConfiguration(
    clipRange: Optional[zio.aws.mediatailor.model.ClipRange] = Optional.Absent,
    transition: Optional[zio.aws.mediatailor.model.UpdateProgramTransition] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.mediatailor.model.UpdateProgramScheduleConfiguration = {
    import UpdateProgramScheduleConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.mediatailor.model.UpdateProgramScheduleConfiguration
      .builder()
      .optionallyWith(clipRange.map(value => value.buildAwsValue()))(
        _.clipRange
      )
      .optionallyWith(transition.map(value => value.buildAwsValue()))(
        _.transition
      )
      .build()
  }
  def asReadOnly
      : zio.aws.mediatailor.model.UpdateProgramScheduleConfiguration.ReadOnly =
    zio.aws.mediatailor.model.UpdateProgramScheduleConfiguration
      .wrap(buildAwsValue())
}
object UpdateProgramScheduleConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.mediatailor.model.UpdateProgramScheduleConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.mediatailor.model.UpdateProgramScheduleConfiguration =
      zio.aws.mediatailor.model.UpdateProgramScheduleConfiguration(
        clipRange.map(value => value.asEditable),
        transition.map(value => value.asEditable)
      )
    def clipRange: Optional[zio.aws.mediatailor.model.ClipRange.ReadOnly]
    def transition
        : Optional[zio.aws.mediatailor.model.UpdateProgramTransition.ReadOnly]
    def getClipRange
        : ZIO[Any, AwsError, zio.aws.mediatailor.model.ClipRange.ReadOnly] =
      AwsError.unwrapOptionField("clipRange", clipRange)
    def getTransition: ZIO[
      Any,
      AwsError,
      zio.aws.mediatailor.model.UpdateProgramTransition.ReadOnly
    ] = AwsError.unwrapOptionField("transition", transition)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.mediatailor.model.UpdateProgramScheduleConfiguration
  ) extends zio.aws.mediatailor.model.UpdateProgramScheduleConfiguration.ReadOnly {
    override val clipRange
        : Optional[zio.aws.mediatailor.model.ClipRange.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.clipRange())
        .map(value => zio.aws.mediatailor.model.ClipRange.wrap(value))
    override val transition
        : Optional[zio.aws.mediatailor.model.UpdateProgramTransition.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.transition())
        .map(value =>
          zio.aws.mediatailor.model.UpdateProgramTransition.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.mediatailor.model.UpdateProgramScheduleConfiguration
  ): zio.aws.mediatailor.model.UpdateProgramScheduleConfiguration.ReadOnly =
    new Wrapper(impl)
}
