package zio.aws.mediatailor.model
import scala.jdk.CollectionConverters.*
sealed trait MessageType {
  def unwrap: software.amazon.awssdk.services.mediatailor.model.MessageType
}
object MessageType {
  def wrap(
      value: software.amazon.awssdk.services.mediatailor.model.MessageType
  ): zio.aws.mediatailor.model.MessageType = value match {
    case software.amazon.awssdk.services.mediatailor.model.MessageType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.mediatailor.model.MessageType.SPLICE_INSERT =>
      val r = SPLICE_INSERT
      r
    case software.amazon.awssdk.services.mediatailor.model.MessageType.TIME_SIGNAL =>
      val r = TIME_SIGNAL
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.mediatailor.model.MessageType {
    override def unwrap
        : software.amazon.awssdk.services.mediatailor.model.MessageType =
      software.amazon.awssdk.services.mediatailor.model.MessageType.UNKNOWN_TO_SDK_VERSION
  }
  case object SPLICE_INSERT extends zio.aws.mediatailor.model.MessageType {
    override def unwrap
        : software.amazon.awssdk.services.mediatailor.model.MessageType =
      software.amazon.awssdk.services.mediatailor.model.MessageType.SPLICE_INSERT
  }
  case object TIME_SIGNAL extends zio.aws.mediatailor.model.MessageType {
    override def unwrap
        : software.amazon.awssdk.services.mediatailor.model.MessageType =
      software.amazon.awssdk.services.mediatailor.model.MessageType.TIME_SIGNAL
  }
}
