package zio.aws.mediatailor.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.mediatailor.model.primitives.__integer
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class HlsPlaylistSettings(
    adMarkupType: Optional[Iterable[zio.aws.mediatailor.model.AdMarkupType]] =
      Optional.Absent,
    manifestWindowSeconds: Optional[__integer] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.mediatailor.model.HlsPlaylistSettings = {
    import HlsPlaylistSettings.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.mediatailor.model.HlsPlaylistSettings
      .builder()
      .optionallyWith(
        adMarkupType.map(value =>
          value.map { item =>
            item.unwrap.toString
          }.asJavaCollection
        )
      )(_.adMarkupTypeWithStrings)
      .optionallyWith(manifestWindowSeconds.map(value => value: Integer))(
        _.manifestWindowSeconds
      )
      .build()
  }
  def asReadOnly: zio.aws.mediatailor.model.HlsPlaylistSettings.ReadOnly =
    zio.aws.mediatailor.model.HlsPlaylistSettings.wrap(buildAwsValue())
}
object HlsPlaylistSettings {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.mediatailor.model.HlsPlaylistSettings
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.mediatailor.model.HlsPlaylistSettings =
      zio.aws.mediatailor.model.HlsPlaylistSettings(
        adMarkupType.map(value => value),
        manifestWindowSeconds.map(value => value)
      )
    def adMarkupType: Optional[List[zio.aws.mediatailor.model.AdMarkupType]]
    def manifestWindowSeconds: Optional[__integer]
    def getAdMarkupType
        : ZIO[Any, AwsError, List[zio.aws.mediatailor.model.AdMarkupType]] =
      AwsError.unwrapOptionField("adMarkupType", adMarkupType)
    def getManifestWindowSeconds: ZIO[Any, AwsError, __integer] =
      AwsError.unwrapOptionField("manifestWindowSeconds", manifestWindowSeconds)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.mediatailor.model.HlsPlaylistSettings
  ) extends zio.aws.mediatailor.model.HlsPlaylistSettings.ReadOnly {
    override val adMarkupType
        : Optional[List[zio.aws.mediatailor.model.AdMarkupType]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.adMarkupType())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.mediatailor.model.AdMarkupType.wrap(item)
          }.toList
        )
    override val manifestWindowSeconds: Optional[__integer] =
      zio.aws.core.internal
        .optionalFromNullable(impl.manifestWindowSeconds())
        .map(value => value: __integer)
  }
  def wrap(
      impl: software.amazon.awssdk.services.mediatailor.model.HlsPlaylistSettings
  ): zio.aws.mediatailor.model.HlsPlaylistSettings.ReadOnly = new Wrapper(impl)
}
