package zio.aws.mediatailor.model
import zio.aws.mediatailor.model.primitives.__string
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class DefaultSegmentDeliveryConfiguration(
    baseUrl: Optional[__string] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.mediatailor.model.DefaultSegmentDeliveryConfiguration = {
    import DefaultSegmentDeliveryConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.mediatailor.model.DefaultSegmentDeliveryConfiguration
      .builder()
      .optionallyWith(baseUrl.map(value => value: java.lang.String))(_.baseUrl)
      .build()
  }
  def asReadOnly
      : zio.aws.mediatailor.model.DefaultSegmentDeliveryConfiguration.ReadOnly =
    zio.aws.mediatailor.model.DefaultSegmentDeliveryConfiguration
      .wrap(buildAwsValue())
}
object DefaultSegmentDeliveryConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.mediatailor.model.DefaultSegmentDeliveryConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.mediatailor.model.DefaultSegmentDeliveryConfiguration =
      zio.aws.mediatailor.model
        .DefaultSegmentDeliveryConfiguration(baseUrl.map(value => value))
    def baseUrl: Optional[__string]
    def getBaseUrl: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("baseUrl", baseUrl)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.mediatailor.model.DefaultSegmentDeliveryConfiguration
  ) extends zio.aws.mediatailor.model.DefaultSegmentDeliveryConfiguration.ReadOnly {
    override val baseUrl: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.baseUrl())
      .map(value => value: __string)
  }
  def wrap(
      impl: software.amazon.awssdk.services.mediatailor.model.DefaultSegmentDeliveryConfiguration
  ): zio.aws.mediatailor.model.DefaultSegmentDeliveryConfiguration.ReadOnly =
    new Wrapper(impl)
}
