package zio.aws.mediatailor.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.mediatailor.model.primitives.__integer
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class DashPlaylistSettings(
    manifestWindowSeconds: Optional[__integer] = Optional.Absent,
    minBufferTimeSeconds: Optional[__integer] = Optional.Absent,
    minUpdatePeriodSeconds: Optional[__integer] = Optional.Absent,
    suggestedPresentationDelaySeconds: Optional[__integer] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.mediatailor.model.DashPlaylistSettings = {
    import DashPlaylistSettings.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.mediatailor.model.DashPlaylistSettings
      .builder()
      .optionallyWith(manifestWindowSeconds.map(value => value: Integer))(
        _.manifestWindowSeconds
      )
      .optionallyWith(minBufferTimeSeconds.map(value => value: Integer))(
        _.minBufferTimeSeconds
      )
      .optionallyWith(minUpdatePeriodSeconds.map(value => value: Integer))(
        _.minUpdatePeriodSeconds
      )
      .optionallyWith(
        suggestedPresentationDelaySeconds.map(value => value: Integer)
      )(_.suggestedPresentationDelaySeconds)
      .build()
  }
  def asReadOnly: zio.aws.mediatailor.model.DashPlaylistSettings.ReadOnly =
    zio.aws.mediatailor.model.DashPlaylistSettings.wrap(buildAwsValue())
}
object DashPlaylistSettings {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.mediatailor.model.DashPlaylistSettings
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.mediatailor.model.DashPlaylistSettings =
      zio.aws.mediatailor.model.DashPlaylistSettings(
        manifestWindowSeconds.map(value => value),
        minBufferTimeSeconds.map(value => value),
        minUpdatePeriodSeconds.map(value => value),
        suggestedPresentationDelaySeconds.map(value => value)
      )
    def manifestWindowSeconds: Optional[__integer]
    def minBufferTimeSeconds: Optional[__integer]
    def minUpdatePeriodSeconds: Optional[__integer]
    def suggestedPresentationDelaySeconds: Optional[__integer]
    def getManifestWindowSeconds: ZIO[Any, AwsError, __integer] =
      AwsError.unwrapOptionField("manifestWindowSeconds", manifestWindowSeconds)
    def getMinBufferTimeSeconds: ZIO[Any, AwsError, __integer] =
      AwsError.unwrapOptionField("minBufferTimeSeconds", minBufferTimeSeconds)
    def getMinUpdatePeriodSeconds: ZIO[Any, AwsError, __integer] = AwsError
      .unwrapOptionField("minUpdatePeriodSeconds", minUpdatePeriodSeconds)
    def getSuggestedPresentationDelaySeconds: ZIO[Any, AwsError, __integer] =
      AwsError.unwrapOptionField(
        "suggestedPresentationDelaySeconds",
        suggestedPresentationDelaySeconds
      )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.mediatailor.model.DashPlaylistSettings
  ) extends zio.aws.mediatailor.model.DashPlaylistSettings.ReadOnly {
    override val manifestWindowSeconds: Optional[__integer] =
      zio.aws.core.internal
        .optionalFromNullable(impl.manifestWindowSeconds())
        .map(value => value: __integer)
    override val minBufferTimeSeconds: Optional[__integer] =
      zio.aws.core.internal
        .optionalFromNullable(impl.minBufferTimeSeconds())
        .map(value => value: __integer)
    override val minUpdatePeriodSeconds: Optional[__integer] =
      zio.aws.core.internal
        .optionalFromNullable(impl.minUpdatePeriodSeconds())
        .map(value => value: __integer)
    override val suggestedPresentationDelaySeconds: Optional[__integer] =
      zio.aws.core.internal
        .optionalFromNullable(impl.suggestedPresentationDelaySeconds())
        .map(value => value: __integer)
  }
  def wrap(
      impl: software.amazon.awssdk.services.mediatailor.model.DashPlaylistSettings
  ): zio.aws.mediatailor.model.DashPlaylistSettings.ReadOnly = new Wrapper(impl)
}
