package zio.aws.mediatailor.model
import zio.aws.mediatailor.model.primitives.__string
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class Bumper(
    endUrl: Optional[__string] = Optional.Absent,
    startUrl: Optional[__string] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.mediatailor.model.Bumper = {
    import Bumper.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.mediatailor.model.Bumper
      .builder()
      .optionallyWith(endUrl.map(value => value: java.lang.String))(_.endUrl)
      .optionallyWith(startUrl.map(value => value: java.lang.String))(
        _.startUrl
      )
      .build()
  }
  def asReadOnly: zio.aws.mediatailor.model.Bumper.ReadOnly =
    zio.aws.mediatailor.model.Bumper.wrap(buildAwsValue())
}
object Bumper {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.mediatailor.model.Bumper
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.mediatailor.model.Bumper = zio.aws.mediatailor.model
      .Bumper(endUrl.map(value => value), startUrl.map(value => value))
    def endUrl: Optional[__string]
    def startUrl: Optional[__string]
    def getEndUrl: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("endUrl", endUrl)
    def getStartUrl: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("startUrl", startUrl)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.mediatailor.model.Bumper
  ) extends zio.aws.mediatailor.model.Bumper.ReadOnly {
    override val endUrl: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.endUrl())
      .map(value => value: __string)
    override val startUrl: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.startUrl())
      .map(value => value: __string)
  }
  def wrap(
      impl: software.amazon.awssdk.services.mediatailor.model.Bumper
  ): zio.aws.mediatailor.model.Bumper.ReadOnly = new Wrapper(impl)
}
