package zio.aws.mediatailor.model
import zio.aws.mediatailor.model.primitives.__string
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class AvailSuppression(
    fillPolicy: Optional[zio.aws.mediatailor.model.FillPolicy] =
      Optional.Absent,
    mode: Optional[zio.aws.mediatailor.model.Mode] = Optional.Absent,
    value: Optional[__string] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.mediatailor.model.AvailSuppression = {
    import AvailSuppression.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.mediatailor.model.AvailSuppression
      .builder()
      .optionallyWith(fillPolicy.map(value => value.unwrap))(_.fillPolicy)
      .optionallyWith(mode.map(value => value.unwrap))(_.mode)
      .optionallyWith(value.map(value => value: java.lang.String))(_.value)
      .build()
  }
  def asReadOnly: zio.aws.mediatailor.model.AvailSuppression.ReadOnly =
    zio.aws.mediatailor.model.AvailSuppression.wrap(buildAwsValue())
}
object AvailSuppression {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.mediatailor.model.AvailSuppression
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.mediatailor.model.AvailSuppression =
      zio.aws.mediatailor.model.AvailSuppression(
        fillPolicy.map(value => value),
        mode.map(value => value),
        value.map(value => value)
      )
    def fillPolicy: Optional[zio.aws.mediatailor.model.FillPolicy]
    def mode: Optional[zio.aws.mediatailor.model.Mode]
    def value: Optional[__string]
    def getFillPolicy
        : ZIO[Any, AwsError, zio.aws.mediatailor.model.FillPolicy] =
      AwsError.unwrapOptionField("fillPolicy", fillPolicy)
    def getMode: ZIO[Any, AwsError, zio.aws.mediatailor.model.Mode] =
      AwsError.unwrapOptionField("mode", mode)
    def getValue: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("value", value)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.mediatailor.model.AvailSuppression
  ) extends zio.aws.mediatailor.model.AvailSuppression.ReadOnly {
    override val fillPolicy: Optional[zio.aws.mediatailor.model.FillPolicy] =
      zio.aws.core.internal
        .optionalFromNullable(impl.fillPolicy())
        .map(value => zio.aws.mediatailor.model.FillPolicy.wrap(value))
    override val mode: Optional[zio.aws.mediatailor.model.Mode] =
      zio.aws.core.internal
        .optionalFromNullable(impl.mode())
        .map(value => zio.aws.mediatailor.model.Mode.wrap(value))
    override val value: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.value())
      .map(value => value: __string)
  }
  def wrap(
      impl: software.amazon.awssdk.services.mediatailor.model.AvailSuppression
  ): zio.aws.mediatailor.model.AvailSuppression.ReadOnly = new Wrapper(impl)
}
